package com.seatel.mobilehall.util.customview;

import android.content.Context;
import android.graphics.Typeface;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;

import androidx.appcompat.widget.AppCompatEditText;

import com.seatel.mobilehall.util.FontCache;
import com.seatel.mobilehall.util.lang.LanguageManager;

public class CustomEditText extends AppCompatEditText {

    private String prefix, fix;
    public static final String ANDROID_SCHEMA = "http://schemas.android.com/apk/res/android";

    public CustomEditText(Context context) {
        super(context);
        this.prefix = this.getText().toString().trim();
        init();
    }

    public CustomEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.prefix = this.getText().toString().trim();
        init();
        applyCustomFont(context, attrs);
    }

    public CustomEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.prefix = this.getText().toString().trim();
        init();
        applyCustomFont(context, attrs);
    }

    public void setPrefix(String s) {
        this.prefix = s;
        setText(s);
    }

    @Override
    public CharSequence getHint() {
        CharSequence hint = super.getHint();
        if (hint != null && !isInEditMode())
            return new LanguageManager(getContext()).translateWords(getContext(), hint.toString());
        else
            return super.getHint();
    }

    private void init() {
        super.setHint(getHint());
        addTextChangedListener(new TextWatcher() {
            public void afterTextChanged(Editable s) {

            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                fix = s.toString().replace(prefix, "");
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String string = s.toString();
                int fl = prefix.length();
                int sl = string.length();
                if (sl < fl) {
                    String in = prefix + string;
                    if (TextUtils.equals(prefix.trim(), string.trim()))
                        in = prefix;
                    setText(in);
                    setSelection(in.length());
                } else {
                    String cek = string.substring(0, fl);
                    if (!cek.equals(prefix)) {
                        if (string.matches(rubah(prefix))) {
                            String in = prefix + string.replace(prefix, "");
                            setText(in);
                            setSelection(in.length());
                        } else {
                            String in = prefix + fix;
                            setText(in);
                            setSelection(in.length());
                        }
                    }
                }
            }
        });
    }

    private void applyCustomFont(Context context, AttributeSet attrs) {
        if (!isInEditMode()) {
            int textStyle = Typeface.NORMAL;
            if (attrs != null)
                textStyle = attrs.getAttributeIntValue(ANDROID_SCHEMA, "textStyle", Typeface.NORMAL);
            String customFont = FontCache.INSTANCE.getFont(getContext(), textStyle);
            Typeface plain = FontCache.INSTANCE.get(getContext(), customFont);
            CustomEditText.this.setTypeface(plain, super.getTypeface().getStyle());
        }
    }

    private String rubah(String s) {
        s = s.replace("+", "\\+").replace("$", "\\$").replace("^", "\\^").replace("*", "\\*").replace("?", "\\?");
        return s;
    }
}
