package com.seatel.mobilehall.util;

import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.os.CancellationSignal;
import android.widget.ImageView;
import android.widget.Toast;

import androidx.annotation.RequiresApi;

import com.bumptech.glide.Glide;
import com.seatel.mobilehall.R;


/**
 * Small helper class to manage text/icon around fingerprint authentication UI.
 */

@RequiresApi(api = Build.VERSION_CODES.M)
public class FingerprintUiHelper extends FingerprintManager.AuthenticationCallback {

    private static final long ERROR_TIMEOUT_MILLIS = 1000;
    private static final long SUCCESS_DELAY_MILLIS = 1;
    private static final long RESET_IMAGE_MILLIS =1100;

    private final FingerprintManager mFingerprintManager;
    private final ImageView mIcon;
    private final Callback mCallback;
    private CancellationSignal mCancellationSignal;
    private final Context context;
    private boolean mSelfCancelled;
    private  String messageError = "";
    private FingerprintManager.CryptoObject cryptoObject;
    private String identify = "login";

    public FingerprintUiHelper(Context context, String identify, FingerprintManager fingerprintManager,
                               ImageView icon, String messageError, Callback callback) {
        mFingerprintManager = fingerprintManager;
        this.identify = identify;
        mIcon = icon;
        mCallback = callback;
        this.context = context;
        this.messageError = messageError;
        mCancellationSignal = new CancellationSignal();

    }
    public boolean isFingerprintAuthAvailable() {
        // The line below prevents the false positive inspection from Android Studio
        // noinspection ResourceType
        return mFingerprintManager.isHardwareDetected()
                && mFingerprintManager.hasEnrolledFingerprints();
    }

    public void startListening(FingerprintManager.CryptoObject cryptoObject) {
        try{
            if (!isFingerprintAuthAvailable()) {
                return;
            }
            this.cryptoObject = cryptoObject;
            mSelfCancelled = false;
            // The line below prevents the false positive inspection from Android Studio
            // noinspection ResourceType
            mFingerprintManager
                    .authenticate(cryptoObject, mCancellationSignal, 0 /* flags */, this, null);

            if (identify.equals("login")){
                Glide.with(context).load(R.drawable.gif_fingerprint_normal_log).into(mIcon);
            }else Glide.with(context).load(R.drawable.gif_fingerprint_normal_con).into(mIcon);

        }catch (IllegalArgumentException e){
            e.printStackTrace();
        }
    }

    public void stopListening() {
        if (mCancellationSignal != null) {
            mSelfCancelled = true;
            mCancellationSignal.cancel();
            mCancellationSignal = null;
        }
    }

    @Override
    public void onAuthenticationError(int errMsgId, CharSequence errString) {
        /*if (errMsgId == FingerprintManager.FINGERPRINT_ERROR_CANCELED){
            stopListening();
            startListening(this.cryptoObject);
        }*/
        if (!mSelfCancelled) {
            /*if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                showError(errString);
            }*/
            mIcon.postDelayed(new Runnable() {
                @Override
                public void run() {
                    mCallback.onError();
                }
            }, ERROR_TIMEOUT_MILLIS);
        }
    }

    @Override
    public void onAuthenticationHelp(int helpMsgId, CharSequence helpString) {
        showError(helpString);
    }

    @Override
    public void onAuthenticationFailed() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            showError("AuthenticationFailed");
        }
    }

    @Override
    public void onAuthenticationSucceeded(FingerprintManager.AuthenticationResult result) {
        mIcon.postDelayed(new Runnable() {
            @Override
            public void run() {
                mCallback.onAuthenticated();
            }
        }, SUCCESS_DELAY_MILLIS);
    }

    private void showError(CharSequence error) {

        if (identify.equals("login")){
            Glide.with(context).load(R.drawable.gif_fingerprint_error_log).into(mIcon);
            mIcon.postDelayed(new Runnable() {
                @Override
                public void run() {
                    Glide.with(context).load(R.drawable.gif_fingerprint_normal_log).into(mIcon);
                }
            }, RESET_IMAGE_MILLIS);
        }else {
            Glide.with(context).load(R.drawable.gif_fingerprint_error_con).into(mIcon);
            mIcon.postDelayed(new Runnable() {
                @Override
                public void run() {
                    Glide.with(context).load(R.drawable.gif_fingerprint_normal_con).into(mIcon);
                }
            }, RESET_IMAGE_MILLIS);
        }

        Toast.makeText(context, messageError, Toast.LENGTH_SHORT).show();

    }

    public interface Callback {

        void onAuthenticated();

        void onError();
    }
}
