package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import com.seatel.mobilehall.databinding.ActivitySuccessRedeemBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity

class SuccessRedeemActivity : BaseActivity<ActivitySuccessRedeemBinding>() {

    companion object {
        fun launch(context: Context, message: String, description: String) {
            val intent = Intent(context, SuccessRedeemActivity::class.java)
            intent.putExtra("message", message)
            intent.putExtra("description", description)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivitySuccessRedeemBinding {
        return ActivitySuccessRedeemBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()
        binding.ivBack.setOnClickListener {
            onBackPressed()
        }

        binding.title.text = intent.getStringExtra("message")
        binding.description.text = intent.getStringExtra("description")
    }


    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()

    }
}