package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.Bundle
import androidx.annotation.RequiresApi
import coil.load
import com.seatel.mobilehall.databinding.ActivityRewardHistoryDetailBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.model.RewardHistoryData
import com.seatel.mobilehall.util.SeatelUtils

class RewardHistoryDetailActivity : BaseActivity<ActivityRewardHistoryDetailBinding>() {

    companion object {
        fun launch(context: Context, rewardHistoryData: RewardHistoryData) {
            val intent = Intent(context, RewardHistoryDetailActivity::class.java)
            intent.putExtra("rewardHistoryModel", rewardHistoryData)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityRewardHistoryDetailBinding {
        return ActivityRewardHistoryDetailBinding.inflate(layoutInflater)
    }

    @RequiresApi(Build.VERSION_CODES.TIRAMISU)
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()

        val rewardData: RewardHistoryData? = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            intent.getParcelableExtra("rewardHistoryModel", RewardHistoryData::class.java)
        } else {
            intent.getParcelableExtra("rewardHistoryModel")
        }

        rewardData?.let {

            binding.tvRewardImg.load(it.rewardImage) {
                crossfade(true)
            }

            binding.tvRewardName.text = it.rewardName
            binding.tvRewardStatus.text = it.status
            binding.tvRewardCode.text = it.redeemCode
            binding.tvRewardExpiry.text = SeatelUtils.formatDateCoin(it.expiredAt)
            binding.tvRewardDate.text = SeatelUtils.formatDateCoin(it.createdAt)
        }
    }


    override fun getStringToolbarTitle(): String? {
        return "Rewards"
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }
}