package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityLoykobBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.interactor.ProductServiceButtonClick
import com.seatel.mobilehall.ui.home.interactor.ProductServiceDetailInteractor
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.ui.home.presenter.ProductServiceDetailPrsenter
import com.seatel.mobilehall.ui.packages.adapter.LoyKobsAdapter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.customview.ErrorHandleView

class LoyKobActivity : BaseActivity<ActivityLoykobBinding>(), ProductServiceDetailInteractor.View,
    ProductServiceButtonClick {

    private var TAG = "LoyKobActivity::>>>"
    private var mPlanCode: String? = null
    private var canSubscribe: Boolean = false
    private var valueData: String? = null
    private var name: String? = null
    private var planType: String? = null
    override fun getViewBinding(): ActivityLoykobBinding {
        return ActivityLoykobBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
      //  setContentView(R.layout.activity_loykob)
        activityEnterRightAnimation()
        binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        getDataIntent()
        init()
    }

    private fun getDataIntent() {
        canSubscribe = intent.getBooleanExtra("CAN_SUBSCRIBE", false)
        mPlanCode = intent.getStringExtra("PLAN_CODE")
        planType = intent.getStringExtra("planType")
    }

    private fun init() {
        ProductServiceDetailPrsenter(this, this).onProServiceDetail(mPlanCode!!, getPhoneLogin())
    }

    override fun onProServiceDetailSucceed(valuePackSectionModel: ValuePackSectionModel) {
        Log.d(TAG, "responseData:>>> $valuePackSectionModel")
        binding.errorView.visibility = View.GONE
        if (planType.equals(Constant.LoyKob)) {
            binding.recyclerItemLoyKob.adapter =
                LoyKobsAdapter(this, Constant.LoyKob, canSubscribe, valuePackSectionModel)
        } else
            binding.recyclerItemLoyKob.adapter =
                LoyKobsAdapter(this, "Any", canSubscribe, valuePackSectionModel)


    }


    private fun getTermAndServiceEn(str: String): List<String> {
        val data = ArrayList<String>()
        data.add(str)
        return data
    }

    override fun onProServiceDetailFailed(error: VolleyError) {
        when (error) {
            is TimeoutError -> {
                binding.errorView.errorMessage = getString(R.string.connection_timeout)
                binding.errorView.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }

            is NoConnectionError -> {
                binding.errorView.errorMessage = getString(R.string.message_no_internet)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }

            else -> {
                binding.errorView.errorMessage = getString(R.string.no_data)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }
    }

    override fun getToolbarTitle(): String {
        mPlanCode = intent.getStringExtra("PLAN_CODE")
        return when (mPlanCode) {
            Constant.LoyKob -> "Loy Kob"
            "internet-pack" -> "Data Pack"
            else -> mPlanCode.toString()
        }
    }


    companion object {
        fun launch(
            context: Context, canSubscribe: Boolean, planCode: String, planType: String
        ) {
            val intent = Intent(context, LoyKobActivity::class.java)
            intent.putExtra("PLAN_CODE", planCode)
            intent.putExtra("CAN_SUBSCRIBE", canSubscribe)
            intent.putExtra("planType", planType)
            context.startActivity(intent)
        }

    }

    override fun buttonActive(
        dataValuePack: ValuePackTableModel,
        amountMB: String,
        pricetMB: String,
        account: String,
        dayPlan: Int,
        type: String
    ) {

    }

    override fun confirmBuy(
        validity: String,
        fee: String,
        data: String,
        pricePlanCode: String,
        isAddon: Boolean
    ) {
        when {
            isAddon -> ConfirmBuyDataPackActivity.launch(
                this,
                name!!,
                valueData!!,
                validity,
                fee,
                data,
                pricePlanCode,
                true
            )

            else -> ConfirmBuyDataPackActivity.launch(
                this,
                name!!,
                valueData!!,
                validity,
                fee,
                data,
                pricePlanCode,
                false
            )
        }
    }


}