package com.seatel.mobilehall.ui.base.adapter

import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.ui.base.fragment.BaseFragment

/**
 *
 *
 * @author Noel
 * @version
 * @created on 18-Oct-18
 */
abstract class BaseListFragment : BaseFragment() {
    protected var mRecyclerView: RecyclerView? = null
    protected var mLayoutManager: RecyclerView.LayoutManager? = null
    protected lateinit var mAdapter: RecyclerView.Adapter<RecyclerView.ViewHolder>


    private var totalItemCount: Int = 0
    private var lastVisibleItem: Int = 0
    protected var isAllLoadedItem: Boolean = false
    protected var loading: Boolean = true
    private val visibleThreshold = 5

    //    protected var limit = 20
    protected var offset = 0
    protected var isScrolling = false
    protected var isScrollDown = false

    private val onScrollListener: RecyclerView.OnScrollListener =
        object : RecyclerView.OnScrollListener() {
            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                super.onScrolled(recyclerView, dx, dy)
                if (mRecyclerView?.layoutManager is LinearLayoutManager) {
                    if (dy > 0) {
//                    if (isFirstLoadData && !loading) {
//                        loadFirstData()
//                    } else {
                        if (!loading && !isAllLoadedItem) {
                            val linearLayoutManager =
                                mRecyclerView?.layoutManager as LinearLayoutManager
                            totalItemCount = linearLayoutManager.itemCount
                            lastVisibleItem = linearLayoutManager.findLastVisibleItemPosition()
                            if (totalItemCount <= lastVisibleItem + visibleThreshold) {
                                loading = true
                                loadMore()
                            }
//                        }
                        }
                        isScrollDown = true
                        onScrollUp()
                    } else {
                        isScrollDown = false
                        onScrollDown()
                    }
                }
            }

            override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                super.onScrollStateChanged(recyclerView, newState)
                when (newState) {
                    RecyclerView.SCROLL_STATE_IDLE -> {
                        onStopScroll()
                        isScrolling = false
                    }
                    RecyclerView.SCROLL_STATE_DRAGGING -> {
                        onScrolling()
                        isScrolling = true
                    }
                }
            }
        }

    abstract fun initRecyclerView(): RecyclerView

    abstract fun initLayoutManager(): RecyclerView.LayoutManager

    abstract fun initAdapter(): RecyclerView.Adapter<RecyclerView.ViewHolder>

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initListRecycler()
        init()
        initEvent()
    }

    protected fun initListRecycler() {
        mRecyclerView = initRecyclerView()
        mLayoutManager = initLayoutManager()
        mAdapter = initAdapter()
        mRecyclerView?.setHasFixedSize(true)
        mRecyclerView?.layoutManager = mLayoutManager
        mRecyclerView?.adapter = mAdapter
    }

    open fun init() {

    }

    open fun initEvent() {
        mRecyclerView?.addOnScrollListener(onScrollListener)
    }

    open fun loadMore() {

    }

    protected fun returnDefaultLimitOffset() {
        offset = 0
        isAllLoadedItem = false
        loading = false
    }

    open fun limit(): Int {
        return 20
    }

    protected open fun onScrollUp() {

    }

    protected open fun onScrollDown() {
    }

    protected open fun onScrolling() {}

    protected open fun onStopScroll() {}

}