package com.seatel.mobilehall.ui.yes_member.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.databinding.ItemPartnerCategoryListBinding
import com.seatel.mobilehall.ui.yes_member.activity.PartnerSearchCategoryDetailActivity
import com.seatel.mobilehall.ui.yes_member.model.PartnerSearchCategoryModel

class PartnerSearchCategoryListAdapter(
    private var mContext: Context,
    private var partnerModelItem: ArrayList<PartnerSearchCategoryModel>
) : RecyclerView.Adapter<PartnerSearchCategoryListAdapter.ViewHolder>() {

    class ViewHolder(var binding: ItemPartnerCategoryListBinding) :
        RecyclerView.ViewHolder(binding.root) {
        fun bind(context: Context, partnerModelItem: PartnerSearchCategoryModel) {

            Glide.with(context).load(partnerModelItem.icon).into(binding.ivIcon)

            binding.tvPartnerName.text = partnerModelItem.name
            binding.tvPartnerOutlet.text = partnerModelItem.totalOutlet.toString() + " Outlet"
            binding.btnDiscount.text = partnerModelItem.discountDesc

        }
    }

    fun updateList(newList: ArrayList<PartnerSearchCategoryModel>) {
        partnerModelItem = newList
        notifyDataSetChanged() // Refresh RecyclerView
    }


    override fun onCreateViewHolder(
        parent: ViewGroup, viewType: Int
    ): ViewHolder {
        val binding = ItemPartnerCategoryListBinding.inflate(
            LayoutInflater.from(parent.context), parent, false
        )
        return ViewHolder(binding)
    }

    override fun getItemCount(): Int {
        return partnerModelItem.size
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val data = partnerModelItem[position]
        holder.bind(mContext, data)
        holder.itemView.setOnClickListener {
            PartnerSearchCategoryDetailActivity.launch(mContext, data.name)
        }
    }
}