package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.graphics.Canvas
import android.graphics.drawable.Drawable
import android.os.Build
import android.os.Bundle
import androidx.core.content.ContextCompat
import coil.load
import com.google.android.gms.maps.CameraUpdateFactory
import com.google.android.gms.maps.GoogleMap
import com.google.android.gms.maps.OnMapReadyCallback
import com.google.android.gms.maps.SupportMapFragment
import com.google.android.gms.maps.model.BitmapDescriptor
import com.google.android.gms.maps.model.BitmapDescriptorFactory
import com.google.android.gms.maps.model.LatLng
import com.google.android.gms.maps.model.LatLngBounds
import com.google.android.gms.maps.model.MarkerOptions
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityOutletLocationBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.model.PartnerByNameOutlet

class OutletLocationActivity : BaseActivity<ActivityOutletLocationBinding>(), OnMapReadyCallback {


    companion object {
        fun launch(context: Context, partnerByNameOutlet: PartnerByNameOutlet) {
            val intent = Intent(context, OutletLocationActivity::class.java)
            intent.putExtra("partnerOutlet", partnerByNameOutlet)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityOutletLocationBinding {
        return ActivityOutletLocationBinding.inflate(layoutInflater)
    }

    private lateinit var googleMap: GoogleMap
    private var rewardData: PartnerByNameOutlet? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()

        binding.ivBack.setOnClickListener {
            onBackPressed()
        }

        rewardData =
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                intent.getParcelableExtra("partnerOutlet", PartnerByNameOutlet::class.java)
            } else {
                intent.getParcelableExtra("partnerOutlet")
            }

        val mapFragment =
            supportFragmentManager.findFragmentById(R.id.mapFragment) as SupportMapFragment
        mapFragment.getMapAsync(this)

        binding.tvShopName.text = rewardData?.name
        binding.tvShopDescription.text = rewardData?.description
        binding.tvShopAddress.text = rewardData?.address
        binding.tvShopNumber.text = rewardData?.phoneNumber

        binding.ivShopLogo.load(rewardData?.icon) {
            crossfade(true)
        }

        binding.btnRedeem.setOnClickListener {
            OutLetScanQrActivity.launch(this)
        }


    }


    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }

    override fun onMapReady(map: GoogleMap?) {
        googleMap = map ?: return

        /* val rewardData: PartnerByNameOutlet? =
             if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                 intent.getParcelableExtra("partnerOutlet", PartnerByNameOutlet::class.java)
             } else {
                 intent.getParcelableExtra("partnerOutlet")
             }*/

        rewardData?.let { outlets ->
            val boundsBuilder = LatLngBounds.Builder()

            val latLongParts = outlets.latLong.split(", ")
            if (latLongParts.size == 2) {
                val lat = latLongParts[0].toDoubleOrNull()
                val lng = latLongParts[1].toDoubleOrNull()

                if (lat != null && lng != null) {
                    val outletLocation = LatLng(lat, lng)

                    // Add marker for each outlet
                    googleMap.addMarker(
                        MarkerOptions()
                            .position(outletLocation)
                            .title(outlets.name)
                            .icon(bitmapFromVector(this, R.drawable.ic_map_pin))
                    )

                    // Include this location in the bounds
                    boundsBuilder.include(outletLocation)

                }
            }

            // Move camera to fit all markers
            val bounds = boundsBuilder.build()
            googleMap.animateCamera(CameraUpdateFactory.newLatLngBounds(bounds, 100))
        }
    }

    private fun bitmapFromVector(context: Context, vectorResId: Int): BitmapDescriptor {
        val vectorDrawable: Drawable = ContextCompat.getDrawable(context, vectorResId)
            ?: return BitmapDescriptorFactory.defaultMarker()

        val bitmap = Bitmap.createBitmap(
            vectorDrawable.intrinsicWidth,
            vectorDrawable.intrinsicHeight,
            Bitmap.Config.ARGB_8888
        )
        val canvas = Canvas(bitmap)
        vectorDrawable.setBounds(0, 0, canvas.width, canvas.height)
        vectorDrawable.draw(canvas)

        return BitmapDescriptorFactory.fromBitmap(bitmap)
    }


}