package com.seatel.mobilehall.ui.home.viewholder

import android.content.Context
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.adapter.AdapterParentOrder
import com.seatel.mobilehall.ui.home.interactor.MyOrderInteractor
import com.seatel.mobilehall.ui.home.model.MyOrderListModel

class MyOrderMainRowViewHolder(private var mContext: Context, itemView: View) :
    RecyclerView.ViewHolder(itemView) {

    fun onBind(item1: MyOrderListModel, isHistory: Boolean, mView: MyOrderInteractor.View) {
        val myListCartAdapter = AdapterParentOrder(mContext, item1, isHistory, mView)
        val recylerView = itemView.findViewById<RecyclerView>(R.id.recycler_view_order)
        recylerView.adapter = myListCartAdapter
        recylerView.layoutManager = LinearLayoutManager(mContext)
    }

}