package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.interactor.ProductServiceButtonClick
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.util.customview.CustomButton
import com.seatel.mobilehall.util.customview.CustomTextView


class ProductServiceDetailAdapter(
    private var context: Context,
    private var canSubscribe: Boolean,
    private var productServiceList: List<ValuePackTableModel>,
    private var productServiceListener: ProductServiceButtonClick,
    private var getMainPhoneLogin: String
) :
    BaseAdapter<ProductServiceDetailAdapter.ViewHolder>() {


    class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        val mFee = itemView.findViewById<CustomButton>(R.id.btn_fee)
        val mData = itemView.findViewById<CustomButton>(R.id.btn_data)
        val mValidity = itemView.findViewById<CustomButton>(R.id.btn_validity)
        val mActivation = itemView.findViewById<CustomButton>(R.id.btn_activation)
        val mActivationCode = itemView.findViewById<CustomTextView>(R.id.btn_activation_code)
        val buttonActivation = itemView.findViewById<LinearLayout>(R.id.button_activation)
        val ln_call_sms = itemView.findViewById<LinearLayout>(R.id.ln_call_sms)
        val callMin = itemView.findViewById<CustomButton>(R.id.btn_call_min)
        /*val callSms = itemView.findViewById<CustomButton>(R.id.btn_call_sms)*/
    }

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): ViewHolder {
        return ViewHolder(
            LayoutInflater.from(context)
                .inflate(R.layout.item_product_service_detail, parent, false)
        )
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        setAnimations(holder.itemView, position)
        val mProductServiceList = productServiceList[position]
        holder.mFee.text = mProductServiceList.valuePrice
        holder.mData.text = mProductServiceList.priceChange
        holder.mValidity.text = mProductServiceList.validityDate
        holder.mActivationCode.text = mProductServiceList.activation

        if (!mProductServiceList.benefitOffer.isNullOrBlank()){
            holder.ln_call_sms.visibility = View.VISIBLE
            holder.mData.visibility = View.GONE
            holder.callMin.text = mProductServiceList.benefitOffer
        }

       /* if (!mProductServiceList.callsmsList.isNullOrEmpty()) {
            if (mProductServiceList.callsmsList.size > 1) {
                holder.ln_call_sms.visibility = View.VISIBLE
                holder.callMin.text = mProductServiceList.callsmsList[0]
                holder.callSms.text = mProductServiceList.callsmsList[1]
            }

        }*/

        if (canSubscribe)
            holder.mActivation.visibility = View.VISIBLE

        holder.buttonActivation.setOnClickListener {
            val delay = mProductServiceList.validityDate
            val separated: List<String> = delay.split(" ")
            when {
               /* getMainPhoneLogin.isEmpty() -> {
                    LoginActivity.lunch(context)
                }*/
                canSubscribe -> {
                    when {
                        mProductServiceList.code.isNullOrBlank() -> {
                            productServiceListener.confirmBuy(
                                mProductServiceList.validityDate,
                                mProductServiceList.valuePrice,
                                mProductServiceList.priceChange,
                                "",
                                false
                            )
                        }
                        else -> productServiceListener.confirmBuy(
                            mProductServiceList.validityDate,
                            mProductServiceList.valuePrice,
                            mProductServiceList.priceChange,
                            mProductServiceList.code,
                            false
                        )
                    }

                }

            }
        }

    }

    override fun getItemCount(): Int {
        return productServiceList.size
    }
}