package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ItemOrderViewHolderBinding
import com.seatel.mobilehall.databinding.ItemMyOrderHeaderBinding
import com.seatel.mobilehall.databinding.ItemBottomEhubBinding
import com.seatel.mobilehall.ui.home.interactor.MyOrderInteractor
import com.seatel.mobilehall.ui.home.model.MyOrderItemModel
import com.seatel.mobilehall.ui.home.model.MyOrderListModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.OrderingManager

class AdapterParentOrder(
    private var context: Context,
    private var item1: MyOrderListModel,
    private val isHistory: Boolean,
    private val mView: MyOrderInteractor.View
) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    private val MAX_HOLDER_LENGHT = 1

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            0 -> OrderViewHolder(
                context,
                ItemOrderViewHolderBinding.inflate(LayoutInflater.from(context), parent, false)
            )

            1 -> MyOrderHeaderIdViewHolder(
                context,
                ItemMyOrderHeaderBinding.inflate(LayoutInflater.from(context), parent, false)
            )

            else -> EhubViewHolder(
                context,
                ItemBottomEhubBinding.inflate(LayoutInflater.from(context), parent, false)
            )
        }
    }

    override fun getItemCount(): Int {
        return MAX_HOLDER_LENGHT
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            is OrderViewHolder -> {
                item1.orderData?.let { holder.bind(it, item1, isHistory, mView) }
            }

            is MyOrderHeaderIdViewHolder -> holder.onBind(item1)
            is EhubViewHolder -> {
                holder.onBind()
            }
        }
    }

    // ViewHolder for Order Data
    class OrderViewHolder(
        private var context: Context,
        private val binding: ItemOrderViewHolderBinding
    ) :
        RecyclerView.ViewHolder(binding.root) {
        fun bind(
            myCartModel: ArrayList<MyOrderItemModel>,
            mainData: MyOrderListModel,
            isHistory: Boolean = false,
            mView: MyOrderInteractor.View
        ) {
            val myCartAdapter = MyOrderAdapter(context, myCartModel)

            // Footer Total
            binding.itemBottomEhub.orderQuantity.text = mainData.orderTotalQuantity.toString()
            var totalPrice = mainData.orderTotalPrice
            if (mainData.orderTotalShipmentInsurace != null && mainData.orderTotalShipmentInsurace!! > 0.0) {
                binding.itemBottomEhub.textViewShipmentInsurance.visibility = View.VISIBLE
                binding.itemBottomEhub.shipmentInsuranceTotal.visibility = View.VISIBLE
                binding.itemBottomEhub.shipmentInsuranceTotal.text =
                    "${SeatelUtils.setFormatcurrency(mainData.orderTotalShipmentInsurace!!)}"
                binding.itemBottomEhub.textViewShipmentInsurance.text =
                    "${context.getString(R.string.shipment_insurance)} (${OrderingManager.getInstance().shipmentInsuranceRate * 100}%)"
            } else {
                binding.itemBottomEhub.textViewShipmentInsurance.visibility = View.GONE
                binding.itemBottomEhub.shipmentInsuranceTotal.visibility = View.GONE
            }
            binding.itemBottomEhub.grandTotal.text = "${SeatelUtils.setFormatcurrency(totalPrice)}"

            binding.itemBottomEhub.viewFotterBtn.visibility = View.VISIBLE
            binding.viewTop.status.visibility = View.VISIBLE
            binding.viewTop.status.text =
                SeatelUtils.toCamelCase(mainData.orderStatus?.replace("-", " "))
            binding.viewTop.imgDelete.visibility = View.GONE
            if (isHistory) {
                binding.itemBottomEhub.viewFotterBtn.visibility = View.GONE
                binding.viewTop.imgDelete.visibility = View.VISIBLE
                binding.viewTop.imgDelete.setOnClickListener {
                    mView.onDeletedOrderId(mainData.orderId.toString())
                }
            }

            // Header Order
            binding.viewTop.orderId.text = mainData.orderId.toString()
            binding.viewTop.orderDate.text = SeatelUtils.getDateTime(
                "yyyy-MM-dd",
                Constant.DATE_FORMAT_DISPLAY_ORDER,
                mainData.orderDate
            )
            binding.viewTop.methodType.text =
                if (TextUtils.isEmpty(mainData.paymentMethod)) "N/A" else mainData.paymentMethod
            binding.viewTop.tranId.text =
                if (TextUtils.isEmpty(mainData.tranId)) "N/A" else mainData.tranId

            binding.recyclerViewOrder.adapter = myCartAdapter
            binding.recyclerViewOrder.layoutManager = LinearLayoutManager(context)

            binding.itemBottomEhub.buttonOrderReceived.setOnClickListener {
                mView.onClickConfirmOrder(mainData.orderId.toString())
            }
        }
    }

    // ViewHolder for Header Order Information
    class MyOrderHeaderIdViewHolder(
        private var mContext: Context,
        private val binding: ItemMyOrderHeaderBinding
    ) :
        RecyclerView.ViewHolder(binding.root) {
        fun onBind(item1: MyOrderListModel) {
            binding.orderDate.text =
                SeatelUtils.getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY, item1.orderDate)
            binding.orderId.text = item1.orderId.toString()

            binding.imgDelete.setOnClickListener {
                // Handle delete if needed
            }
        }
    }

    // ViewHolder for Footer Information (Ehub)
    class EhubViewHolder(
        private var mContext: Context,
        private val binding: ItemBottomEhubBinding
    ) :
        RecyclerView.ViewHolder(binding.root) {

        fun onBind() {
            binding.buttonOrderReceived.setOnClickListener {
                // Handle order received click
            }
            binding.buttonTracking.setOnClickListener {
                // Handle tracking click
            }

            binding.orderQuantity.text = "$"
            binding.grandTotal.text = "$"
        }
    }
}
