package com.seatel.mobilehall.ui.home.activity

import android.Manifest
import android.app.Activity
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.net.Uri
import android.os.Bundle
import android.text.TextUtils
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import com.google.android.gms.maps.CameraUpdateFactory
import com.google.android.gms.maps.GoogleMap
import com.google.android.gms.maps.OnMapReadyCallback
import com.google.android.gms.maps.model.BitmapDescriptorFactory
import com.google.android.gms.maps.model.CameraPosition
import com.google.android.gms.maps.model.LatLng
import com.google.android.gms.maps.model.MarkerOptions
import com.google.gson.Gson
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityContactUsBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.model.SeatelShopLocationModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.PermissionUtil

class ContactUsActivity : BaseActivity<ActivityContactUsBinding>(), OnMapReadyCallback {

    private lateinit var shopData: SeatelShopLocationModel
    private var mPhoneNumberRequest: PermissionUtil.PermissionRequestObject? = null
    private var mMap: GoogleMap? = null
    private var mMapLatLong = LatLng(11.541889, 104.921333)

    override fun onMapReady(googleMap: GoogleMap?) {
        googleMap?.uiSettings!!.isScrollGesturesEnabled = false
        googleMap.uiSettings.isZoomControlsEnabled = false
        googleMap.uiSettings.isZoomGesturesEnabled = false
        displayMapMarker(googleMap)
    }

    private fun displayMapMarker(googleMap: GoogleMap?) {
        mMap = googleMap
        setMapLatLong()
    }

    private fun setMapLatLong() {
        if (mMap != null) {
            val mCameraPosition =
                CameraPosition.builder().target(mMapLatLong).zoom(17f).bearing(0.0f).tilt(0.0f)
                    .build()
            mMap!!.moveCamera(CameraUpdateFactory.newCameraPosition(mCameraPosition))
            val icon = BitmapDescriptorFactory.fromResource(R.drawable.ic_map_pin_white_bg)
            val markerOptions = MarkerOptions().icon(icon)
            mMap!!.addMarker(markerOptions.position(mMapLatLong))
        }
    }

    public override fun onResume() {
        super.onResume()
        binding.mapContactUs.onResume()
    }

    public override fun onDestroy() {
        binding.mapContactUs.onDestroy()
        super.onDestroy()
    }

    override fun onLowMemory() {
        binding.mapContactUs.onLowMemory()
        super.onLowMemory()
    }

    public override fun onPause() {
        binding.mapContactUs.onPause()
        super.onPause()
    }

    override fun getViewBinding(): ActivityContactUsBinding {
        return ActivityContactUsBinding.inflate(layoutInflater)
    }

    /*override fun onSaveInstanceState(outState: Bundle?) {
        super.onSaveInstanceState(outState)
        binding.mapContactUs.onSaveInstanceState(outState)
    }
*/
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //   setContentView(R.layout.activity_contact_us)
        binding.mapContactUs.onCreate(savedInstanceState)
        binding.mapContactUs.getMapAsync(this)

        activityEnterRightAnimation()
        val data = intent.getStringExtra(Constant.SHOP_LOCATION_DATA)
        if (!TextUtils.isEmpty(data)) {
            shopData =
                Gson().fromJson<SeatelShopLocationModel>(data, SeatelShopLocationModel::class.java)
            if (shopData != null) {
                binding.tvHeadOffice.text = shopData.name
                binding.ctvAdress.text = shopData.address
                binding.ctvPhoneNumber.text = shopData.contactNumber
                binding.ctvHourWork.text = shopData.hoursWork
                if (TextUtils.isEmpty(shopData.hoursWork)) {
                    binding.ctvHourWork.text = "N/A"
                }
                baseBinding.textViewTitleBar.text = shopData.name
                mMapLatLong = LatLng(shopData.latitude, shopData.longitude)
                setMapLatLong()
            }

            binding.layoutCenter.setOnClickListener {
                showCallDialog()
            }

            binding.btnDirection.setOnClickListener {
                val intent = Intent(
                    android.content.Intent.ACTION_VIEW,
                    Uri.parse("http://maps.google.com/maps?daddr=" + "${mMapLatLong.latitude},${mMapLatLong.longitude}")
                )
                startActivity(intent)
            }
        }

    }

    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {
        mPhoneNumberRequest!!.onRequestPermissionsResult(requestCode, permissions, grantResults)
    }

    private fun requestPermissionLocation() {
        mPhoneNumberRequest = PermissionUtil.with(this).request(Manifest.permission.CALL_PHONE)
            .onAllGranted(object : PermissionUtil.Func() {
                override fun call() {
                    showCallDialScreenPhone()
                }
            }).onAnyDenied(object : PermissionUtil.Func() {
                override fun call() {

                }
            }).askPermission(Constant.REQUEST_LOCATION_PERMISSION_CODE)
    }

    private fun showCallDialScreenPhone() {
        val intent = Intent(Intent.ACTION_DIAL)
        intent.data = Uri.parse("tel:${binding.ctvPhoneNumber.text}")
        this.startActivity(intent)
    }

    private fun showCallDialog() {
        if (ContextCompat.checkSelfPermission(
                this,
                Manifest.permission.CALL_PHONE
            ) != PackageManager.PERMISSION_GRANTED
        ) {
            showCallDialScreenPhone()
        } else {
            requestPermissionLocation()
            ActivityCompat.requestPermissions(
                this as Activity,
                arrayOf(android.Manifest.permission.CALL_PHONE),
                Constant.REQUEST_PHONE_CALL
            )
        }
    }

    override fun getStringToolbarTitle(): String? {
        return getString(R.string.head_office)
    }

    companion object {
        fun lunch(context: Context, shopData: String) {
            val intent = Intent(context, ContactUsActivity::class.java)
            intent.putExtra(Constant.SHOP_LOCATION_DATA, shopData)
            context.startActivity(intent)
        }
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }


}
