package com.seatel.mobilehall.util.request

import android.content.Context
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.home.interactor.LocationShopMapInteractor
import com.seatel.mobilehall.ui.home.model.SeatelShopLocationModel
import com.seatel.mobilehall.util.Constant
import org.json.JSONObject

open class GetShopLocationRequest(context: Context?) : SeatelJSONObjectRequest(context) {
    private var strQuery: String = ""
    private var onSuccess: LocationShopMapInteractor? = null

    override fun getFunctionName(): String {
        return Constant.SHOP_LOCATION + getStrQuery()
    }


    fun setStrQuery(str: String) {
        this.strQuery = str
    }

    fun getStrQuery(): String {
        return strQuery
    }

    open fun setOnSuccess(onSuccess: LocationShopMapInteractor) {
        this.onSuccess = onSuccess
    }


    override fun onResponse(response: JSONObject?) {
        super.onResponse(response)
        var data: JSONObject
        val locationData = ArrayList<SeatelShopLocationModel>()
        val total = response?.optJSONArray("data")?.length()!! - 1
        for (i in 0..total) {
            data = response.optJSONArray("data")?.optJSONObject(i)!!
            val modelLocation = SeatelShopLocationModel(
                data.optString("_id", ""),
                data.optString("name", ""),
                data.optString("address", ""),
                data.optString("contactNumber", ""),
                data.optString("hours", ""),
                data.optDouble("latitude", 11.541889),
                data.optDouble("longitude", 104.921333),
                data.optString("localArea", "")
            )
            locationData.add(modelLocation)
        }
        if (onSuccess != null)
            onSuccess?.onLoadData(locationData)

    }
}