package com.seatel.mobilehall.ui.invite_friend

import android.content.Context
import android.content.Intent
import android.os.Bundle
import com.seatel.mobilehall.databinding.ActivityQrscanSuccessBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.activity.MySubscriptionsActivity
import com.seatel.mobilehall.util.SeatelUtils

class InviteFriendScanSuccessActivity : BaseActivity<ActivityQrscanSuccessBinding>() {


    private var phoneNumber: String? = null
    private var data: String? = null
    private var date: String? = null
    private var title: String? = null
    private var subTitle: String? = null

    companion object {

        fun launch(
            context: Context,
            phoneNumber: String,
            data: String,
            date: String,
            title: String,
            subTitle: String
        ) {
            val intent = Intent(context, InviteFriendScanSuccessActivity::class.java)
            intent.putExtra("PHONE_NUMBER", phoneNumber)
            intent.putExtra("DATA", data)
            intent.putExtra("DATE", date)
            intent.putExtra("TITLE", title)
            intent.putExtra("SUBTITLE", subTitle)
            context.startActivity(intent)
        }

    }

    override fun getViewBinding(): ActivityQrscanSuccessBinding {
        return ActivityQrscanSuccessBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        // setContentView(R.layout.activity_qrscan_success)
        getData()
        binding.viewProfile.setOnClickListener {
            MySubscriptionsActivity.lunch(this)
            finish()
        }
    }


    private fun getData() {
        if (intent.extras != null) {
            phoneNumber = intent.getStringExtra("PHONE_NUMBER")
            data = intent.getStringExtra("DATA")
            date = intent.getStringExtra("DATE")
            title = intent.getStringExtra("TITLE")
            subTitle = intent.getStringExtra("SUBTITLE")
        }

        binding.tvTitle.text = title
        binding.tvSubTitle.text = subTitle
        binding.ivPhoneNumber.text = phoneNumber.toString()
        binding.ivData.text = data.toString()
        binding.ivData.text = SeatelUtils.getDateTime(
            "yyyy-MM-dd", "MMM dd,YYYY HH:mm aa",
            date
        )
    }


    override fun getToolbarTitle(): String {
        return "QR Scan"
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
        gotoMainScreen()
        finish()
    }

}