package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.activity.DeviceDetailActivity
import com.seatel.mobilehall.ui.home.model.DeviceDetailViewModel
import com.seatel.mobilehall.ui.home.model.MyOrderItemModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils

open class MyOrderAdapter(
    private val mContext: Context,
    private val myCartModels: ArrayList<MyOrderItemModel>
) :
    RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            0 -> ViewHolderDevice(
                LayoutInflater.from(mContext).inflate(R.layout.item_order, parent, false)
            )
            1 -> ViewHolderSimCard(
                LayoutInflater.from(mContext)
                    .inflate(R.layout.item_order_sim_card_type, parent, false)
            )
            else -> ViewHolderDevice(
                LayoutInflater.from(mContext).inflate(R.layout.item_order, parent, false)
            )
        }
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            is ViewHolderDevice -> holder.bind(mContext, myCartModels[position])
            is ViewHolderSimCard -> holder.bind(mContext, myCartModels[position])
        }
    }

    override fun getItemCount(): Int {
        return myCartModels.size
    }

    override fun getItemViewType(position: Int): Int {
        val myCartModel = myCartModels[position]
        when (myCartModel.typeItem) {
            Constant.DEVICE -> return 0
            Constant.SIM_CARD -> return 1
            Constant.SRATCH_CARD -> return 2
        }
        return 0
    }

    class ViewHolderDevice(itemView: View) : RecyclerView.ViewHolder(itemView) {
        private val orderDeviceBrand: TextView = itemView.findViewById(R.id.text_view_cart_name)
        private val orderDeviceModel: TextView = itemView.findViewById(R.id.text_view_order_name)
        private val orderPrice: TextView = itemView.findViewById(R.id.text_view_order_price)
        private val orderStorage: TextView =
            itemView.findViewById(R.id.text_view_order_storage_value)
        private val orderColor: TextView = itemView.findViewById(R.id.text_view_order_color_value)
        private val orderQuantity: TextView =
            itemView.findViewById(R.id.text_view_order_quantity_value)
        private val viewStorage: View = itemView.findViewById(R.id.view_storage)
        private val viewColor: View = itemView.findViewById(R.id.view_color)
        private val imgResource: ImageView = itemView.findViewById(R.id.img_order)
        private val imgResourceImage: ImageView = itemView.findViewById(R.id.img_order_device)
        private val imgScratchCard: ImageView = itemView.findViewById(R.id.img_scratch_card)

        fun bind(context: Context, myCartModel: MyOrderItemModel) {
            if (myCartModel.typeItem == Constant.DEVICE) {

                viewStorage.visibility = View.VISIBLE
                viewColor.visibility = View.VISIBLE
                imgResourceImage.visibility = View.VISIBLE
                imgResource.visibility = View.GONE
                imgScratchCard.visibility = View.GONE

                orderQuantity.text = myCartModel.quantity.toString()
                orderStorage.text = "${myCartModel.storage}GB"
                orderColor.text = SeatelUtils.toCamelCase(myCartModel.color)
                orderDeviceBrand.text = SeatelUtils.toCamelCase(myCartModel.brand)
                orderDeviceModel.text = myCartModel.deviceName
                orderPrice.text = "${SeatelUtils.setFormatcurrency(myCartModel.totalPrice)}"
                Glide.with(context).load(myCartModel.itemIcon).into(imgResourceImage)

                itemView.setOnClickListener {
                    val dataDeviceDetailViewer = DeviceDetailViewModel()
                    dataDeviceDetailViewer.isUpdatedCart = false
                    dataDeviceDetailViewer.deviceId = myCartModel.deviceUrl
                    dataDeviceDetailViewer.deviceColor = myCartModel.color
                    dataDeviceDetailViewer.deviceColorCode = myCartModel.colorId
                    dataDeviceDetailViewer.deviceStorage = myCartModel.storage
                    dataDeviceDetailViewer.devicePrice = myCartModel.unitPrice
                    dataDeviceDetailViewer.deviceQty = myCartModel.quantity
                    DeviceDetailActivity.lunchWithResult(context, dataDeviceDetailViewer)
                }

            } else {
                viewStorage.visibility = View.GONE
                viewColor.visibility = View.GONE
                imgResourceImage.visibility = View.GONE
                imgResource.visibility = View.GONE
                imgScratchCard.visibility = View.VISIBLE

                orderDeviceModel.text =
                    "${SeatelUtils.setFormatcurrency(myCartModel.scratchCardAmount)}"
                orderDeviceBrand.text = SeatelUtils.toCamelCase(myCartModel.deviceName)
                val totalPrice = myCartModel.scratchCardAmount!! * myCartModel.quantity!!.toDouble()
                orderPrice.text = "${SeatelUtils.setFormatcurrency(totalPrice)}"

                Glide.with(context).load(myCartModel.itemIcon).into(imgScratchCard)
            }

            orderQuantity.text = myCartModel.quantity.toString()
            Glide.with(context).load(myCartModel.itemIcon).into(imgResource)


        }

    }

    class ViewHolderSimCard(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val recyclerViewSimCard: RecyclerView = itemView.findViewById(R.id.recycler_view_order_sim)

        fun bind(context: Context, myCartModel: MyOrderItemModel) {
            val mySimCardAdapter = myCartModel.dataPlan?.let { MyOrderSimCardAdapter(context, it) }

            recyclerViewSimCard.adapter = mySimCardAdapter
            recyclerViewSimCard.layoutManager = LinearLayoutManager(context)
        }
    }
}
