package com.seatel.mobilehall.data.prefs

import android.content.Context
import android.content.SharedPreferences

class SeatelSharePreferences(context: Context) {

    private var sharedPref: SharedPreferences? = null

    init {
        this.sharedPref = context.getSharedPreferences("SeatelPreferences", Context.MODE_PRIVATE)
    }

    companion object {

        @Volatile
        private var instance: SeatelSharePreferences? = null

        fun getInstance(context: Context): SeatelSharePreferences? {
            if (instance == null)  // NOT thread safe!
                instance = SeatelSharePreferences(context)
            return instance
        }
    }

    fun getLoginSuccess(): String? {
        return sharedPref?.getString("IS_LOGIN_SUCCESS", "")
    }

    fun setLoginSuccess(isSuccess: String?) {
        sharedPref?.edit()?.putString("IS_LOGIN_SUCCESS", isSuccess)?.apply()
    }

    fun getMainPhoneLogin(): String? {
        return sharedPref?.getString("MAIN_PHONE_NUMBER_LOGIN", "")
    }

    fun setMainPhoneLogin(phoneLogin: String) {
        sharedPref?.edit()?.putString("MAIN_PHONE_NUMBER_LOGIN", phoneLogin)?.apply()
    }

    fun getAccessToken(): String? {
        return sharedPref?.getString("ACCESS_TOKEN", "")
    }

    fun setAccessToken(accessToken: String) {
        sharedPref?.edit()?.putString("ACCESS_TOKEN", accessToken)?.apply()
    }

    fun getNoneSeatelNumber(): Boolean? {
        return sharedPref?.getBoolean("IS_NONE_SEATEL_NUMBER", false)
    }

    fun setNoneSeatelNumber(noneSeatelNumber: Boolean) {
        sharedPref?.edit()?.putBoolean("IS_NONE_SEATEL_NUMBER", noneSeatelNumber)?.apply()
    }

    fun getPasswordLogin(): String? {
        return sharedPref?.getString("PASSWORD_NUMBER_LOGIN", "")
    }

    fun setPasswordLogin(passwordLogin: String) {
        sharedPref?.edit()?.putString("PASSWORD_NUMBER_LOGIN", passwordLogin)?.apply()
    }

    fun getPhoneLogin(): String? {
        return sharedPref?.getString("PHONE_NUMBER_LOGIN", "")
    }

    fun setPhoneLogin(phoneLogin: String) {
        sharedPref?.edit()?.putString("PHONE_NUMBER_LOGIN", phoneLogin)?.apply()
    }

    fun setShowClaimFreeSim(freeSim: Boolean?) {
        sharedPref?.edit()?.putBoolean("CLAIM_FREE_SIM_SHOW", freeSim!!)
            ?.apply()
    }

    fun getShowClaimFreeSim(): Boolean? {
        return sharedPref?.getBoolean("CLAIM_FREE_SIM_SHOW", false)
    }


    fun setUserInfo(userInfo: String?) {
        sharedPref?.edit()?.putString("USER_INFO", userInfo)?.apply()
    }

    fun getUserInfo(): String? {
        return sharedPref?.getString("USER_INFO", "")
    }


    fun clearAll() {
        sharedPref!!.edit().clear().apply()
    }

    fun setUsername(username: String?) {
        sharedPref?.edit()?.putString("USER_NAME", username)?.apply()
    }

    fun getUsername(): String? {
        return sharedPref?.getString("USER_NAME", "")
    }

    fun setUserPhone(userPhone: String) {
        sharedPref?.edit()?.putString("USER_PHONE", userPhone)?.apply()
    }

    fun getUserPhone(): String? {
        return sharedPref?.getString("USER_PHONE", "")
    }

    fun getRegisterPush(): Boolean {
        return sharedPref?.getBoolean("IS_REGISTER_PUSH", false)!!
    }

    fun setRegisterPush(isSuccess: Boolean?) {
        sharedPref?.edit()?.putBoolean("IS_REGISTER_PUSH", isSuccess!!)
            ?.apply()
    }


    fun setIsPostPaid(isPostPaid: Boolean?) {
        sharedPref?.edit()?.putBoolean("IS_ACCOUNT_POST_PAID", isPostPaid!!)
            ?.apply()
    }

    fun getIsPostPaid(): Boolean? {
        return sharedPref?.getBoolean("IS_ACCOUNT_POST_PAID", false)
    }

    fun setPhoneFilterCategories(data: String?) {
        sharedPref?.edit()?.putString("PhONE_FILTER_CATEGORIES", data)
            ?.apply()
    }

    fun getPhoneFilterCategories(): String? {
        return sharedPref?.getString("PhONE_FILTER_CATEGORIES", "")
    }

    fun setSubPlan(value: String?) {
        sharedPref?.edit()?.putString("SUB_PLAN", value)?.apply()
    }

    fun getSubPlan(): String? {
        return sharedPref?.getString("SUB_PLAN", "")
    }

    fun setHasInstalmentPlan(value: Boolean?) {
        sharedPref?.edit()?.putBoolean("HAS_INSTALMENT_PLAN", value!!)
            ?.apply()
    }

    fun isHasInstalmentPlan(): Boolean? {
        return sharedPref?.getBoolean("HAS_INSTALMENT_PLAN", false)
    }

    fun setRoamingActivation(value: Boolean?) {
        sharedPref?.edit()?.putBoolean("roamingActivation", value!!)?.apply()
    }

    fun isRoamingActivation(): Boolean? {
        return sharedPref?.getBoolean("roamingActivation", false)

    }

    fun setSpecialSimcard(value: Boolean?) {
        sharedPref?.edit()?.putBoolean("roaming", value!!)?.apply()
    }

    fun isSpecialSimcard(): Boolean? {
        return sharedPref?.getBoolean("roaming", false)
    }

    fun setMainScreenData(mainScreenData: String?) {
        sharedPref?.edit()?.putString("MAIN_SCREEN_DATA", mainScreenData)
            ?.apply()
    }

    fun getMainScreenData(): String? {
        return sharedPref?.getString("MAIN_SCREEN_DATA", "")
    }

    fun setProvinceData(province: Set<String?>?) {
        sharedPref?.edit()?.putStringSet("PROVINCE", province)?.apply()
    }

    fun getProvinceData(): Set<String?>? {
        return sharedPref?.getStringSet("PROVINCE", null)
    }


    fun setHomeCategory(homeCategory: String) {
        sharedPref?.edit()?.putString("HOME_CATEGORY", homeCategory)?.apply()
    }

    fun getHomeCategory(): String? {
        return sharedPref?.getString("HOME_CATEGORY", "")
    }


}