package com.seatel.mobilehall.util.view

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.RelativeLayout
import com.seatel.mobilehall.BuildConfig
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ViewOrderBottomBarBinding
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.manager.OrderingManager
import java.util.*

class OrderBottomBarView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : RelativeLayout(context, attrs, defStyleAttr) {

    private var binding: ViewOrderBottomBarBinding? = null
    private var onButtonClick: OnButtonClick? = null
    private var isClickAbleInsurance: Boolean = true
    private var isCheckInsurance: Boolean = false

    init {
        // Inflate the layout using ViewBinding
        binding = ViewOrderBottomBarBinding.inflate(LayoutInflater.from(context), this, true)

        // Set click listeners using binding views
        binding?.buttonBuy?.setOnClickListener { onButtonClick?.onClick() }
        binding?.checkboxInsurance?.setOnCheckedChangeListener { _, isChecked ->
            if (!isClickAbleInsurance) return@setOnCheckedChangeListener
            binding?.viewCheckInsurance?.alpha = if (isChecked) 1f else 0.5f
            isCheckInsurance = isChecked
            onButtonClick?.onCheckShipInsurance(isChecked)
        }

        binding?.viewCheckInsurance?.setOnClickListener {
            if (!isClickAbleInsurance) return@setOnClickListener
            binding?.checkboxInsurance?.isChecked = !binding?.checkboxInsurance?.isChecked!!
        }

        binding?.ctvInsuranceTitle?.text = "${context.getString(R.string.shipment_insurance)} (${OrderingManager.getInstance().shipmentInsuranceRate * 100}%)"
        binding?.tvTermCondition?.setOnClickListener {
            val uris = Uri.parse("${BuildConfig.BASE_URL}${Constant.urlTerm}")
            val intents = Intent(Intent.ACTION_VIEW, uris)
            val b = Bundle()
            b.putBoolean("new_window", true)
            intents.putExtras(b)
            context.startActivity(intents)
        }
    }

    // Clean up to avoid memory leaks
    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        binding = null
    }

    fun isCheckInsurance(): Boolean {
        return isCheckInsurance
    }

    fun setOnButtonClick(onButtonClick: OnButtonClick) {
        this.onButtonClick = onButtonClick
    }

    fun setTotal(total: Double, itemSizeSelect: Int = 1) {
        binding?.textViewTotalPrice?.text = String.format(Locale.US, "$%.2f", total)
        if (itemSizeSelect > 0 && total >= 0.0 || OrderingManager.getInstance().claimFreeSim || OrderingManager.getInstance().winPromotionFreeSim || OrderingManager.getInstance().skipTopUp)
            show()
        else hide()
    }

    fun setPriceInSurancePhoneDevice(price: Double) {
        binding?.ctvPriceInsurance?.text = String.format(Locale.US, "%.2f", price)
    }

    private fun hide() {
        animate().translationY(height.toFloat())
        postDelayed({ visibility = View.GONE }, 300)
    }

    private fun show() {
        visibility = View.VISIBLE
        animate().translationY(0f).duration = 300
    }

    fun hideShowButtonNext(isShow: Boolean) {
        binding?.buttonBuy?.visibility = if (isShow) View.VISIBLE else View.GONE
    }

    fun hideInsuranceView(isShow: Boolean, unEditable: Boolean = false) {
        binding?.viewCheckInsurance?.visibility = if (isShow) View.VISIBLE else View.GONE
        if (isShow) binding?.viewCheckInsurance?.animate()?.translationY(0f)?.duration = 200
        else binding?.viewCheckInsurance?.animate()?.translationY(50f)?.duration = 900
        binding?.checkboxInsurance?.isClickable = !unEditable
        isClickAbleInsurance = !unEditable
    }

    fun setButtonText(id: Int) {
        setButtonText(context.getString(id))
    }

    fun setButtonText(string: String) {
        binding?.buttonBuy?.text = string
    }

    interface OnButtonClick {
        fun onClick()
        fun onCheckShipInsurance(isCheck: Boolean)
    }
}
