package com.seatel.mobilehall.util.manager

import android.content.Context
import java.io.File

class OrderProfileSingleton(context: Context) {

    private var docType = ""
    private var nationalityId = ""
    private var name = ""
    private var gender = ""
    private var dateOfBirth = ""
    private var frontIdImageUrl: File? = null
    private var backIdImageUrl: File? = null
    private var photo: File? = null


    companion object {
        private var instance: OrderProfileSingleton? = null

        fun getInstance(context: Context): OrderProfileSingleton? {
            if (instance == null)
                instance = OrderProfileSingleton(context)
            return instance
        }

        fun clear() {
            instance = null
        }
    }


    fun setDocType(type: String) {
        this.docType = type
    }

    fun getDocType(): String {
        return docType
    }

    fun setNationalityId(nationalityId: String) {
        this.nationalityId = nationalityId
    }

    fun getNationalityId(): String {
        return nationalityId
    }

    fun setName(name: String) {
        this.name = name
    }

    fun getName(): String {
        return name
    }

    fun setGender(gender: String) {
        this.gender = gender
    }

    fun getGender(): String {
        return gender
    }

    fun setFrontIdImageUrl(frontIdImageUrl: File) {
        this.frontIdImageUrl = frontIdImageUrl
    }

    fun getFrontIdImageUrl(): File {
        return frontIdImageUrl!!
    }

    fun setBackIdImageUrl(backIdImageUrl: File) {
        this.backIdImageUrl = backIdImageUrl
    }

    fun getBackIdImageUrl(): File {
        return backIdImageUrl!!
    }

    fun setPhoto(photo: File) {
        this.photo = photo
    }

    fun getPhoto(): File {
        return photo!!
    }

    fun setDateOfBirth(dateOfBirth: String) {
        this.dateOfBirth = dateOfBirth
    }

    fun getDateOfBirth(): String {
        return dateOfBirth
    }

}