package com.seatel.mobilehall.util.dialogannouncement

import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.view.View
import android.view.ViewGroup
import android.view.Window
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import coil.load
import com.airbnb.lottie.LottieAnimationView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.lang.LanguageManager

class CustomGameDialog(
    context: Context,
    title: String,
    prize: String,
    subtitle: String,
    image: String,
    isDoneShow: Boolean,
    isClaim: Boolean
) : Dialog(context) {

    private var isDimissClose = false
    private lateinit var animationView: LottieAnimationView

    init {
        initValentine(title, prize, subtitle, image, isDoneShow, isClaim)
    }

    fun isDimissClose(): Boolean {
        return isDimissClose
    }

    private fun initValentine(
        title: String,
        prize: String,
        subtitle: String,
        image: String,
        isDoneShow: Boolean,
        isClaim: Boolean
    ) {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        setContentView(R.layout.dialog_game)
        setCancelable(false)
        if (window != null) {
            window!!.setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT
            )
            window!!.attributes.windowAnimations = R.style.DialogAnimationScaleInOut
            window!!.setDimAmount(0.5f)
            window!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        }/* animationView = findViewById(R.id.animation_view)
         animationView.setAnimation(R.raw.test)
         animationView.playAnimation()*/
        val mTitle = findViewById<TextView>(R.id.tv_congratulation)
        val mPrize = findViewById<ImageView>(R.id.iv_data)
        val mSubTitle = findViewById<TextView>(R.id.sub_title)
        val mClaimTitle = findViewById<TextView>(R.id.claim_title)
        // val mSubTitle = findViewById<TextView>(R.id.valentine_subTitle)
        val btnDone = findViewById<Button>(R.id.btn_done)
        val bgImage = findViewById<ImageView>(R.id.imageView2)
        val imageOpenAngPao = findViewById<ImageView>(R.id.image_open_ang_pao)
        btnDone.text = LanguageManager(context).translateWords(
            context, context.resources.getString(R.string.done)
        )



        if (isClaim) {
            mSubTitle.visibility = View.GONE
            mClaimTitle.visibility = View.VISIBLE
            mClaimTitle.text = subtitle
            mPrize.visibility = View.GONE

        } else {
            mPrize.visibility = View.VISIBLE
            mSubTitle.visibility = View.VISIBLE
            mClaimTitle.visibility = View.GONE
        }

        if (image.isNotBlank()) mPrize.load(image) { crossfade(true) }
        else mPrize.visibility = View.GONE

        if (title == "Thank You") {
            //  animationView.cancelAnimation()
            mTitle.visibility = View.GONE
            mSubTitle.visibility = View.GONE
        } else {
            //  animationView.setAnimation(R.raw.cholchoung)
            //  animationView.playAnimation()
            mTitle.text = title
            mSubTitle.text = subtitle
        }



        if (isDoneShow) {
            btnDone.visibility = View.VISIBLE
            bgImage.setImageDrawable(context.resources.getDrawable(R.drawable.bg_dialog_game))
        } else {
            btnDone.visibility = View.GONE
            imageOpenAngPao.visibility = View.GONE
        }
        btnDone.setOnClickListener {
            dismiss()
        }
        val close = findViewById<ImageView>(R.id.valentine_close)
        close.setOnClickListener {
            dismiss()

        }
    }

}