package com.seatel.mobilehall.util.customview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.seatel.mobilehall.R;
import com.seatel.mobilehall.databinding.TermServicePrivacyPolicyBinding;
import com.seatel.mobilehall.ui.login.activity.TermsAndConditionsActivity;

public class TermServicePrivacyPolicyView extends LinearLayout implements View.OnClickListener {

    private TermServicePrivacyPolicyBinding binding;

    public TermServicePrivacyPolicyView(Context context) {
        super(context);
        initView();
    }

    public TermServicePrivacyPolicyView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    public TermServicePrivacyPolicyView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
    }

    public TermServicePrivacyPolicyView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        initView();
    }

    private void initView() {
        // Inflate the layout using ViewBinding
        binding = TermServicePrivacyPolicyBinding.inflate(LayoutInflater.from(getContext()), this, true);

        // Set click listeners using the binding
        binding.termOfService.setOnClickListener(this);
        // binding.privacyPolicy.setOnClickListener(this); // Uncomment if the privacy policy is needed
    }




    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.term_of_service) {
            TermsAndConditionsActivity.Companion.launch(getContext(), "");
            // Handle the click event for Term of Service
            // Example: TermServicePrivatePolicyActivity.launch(getContext(), getContext().getString(R.string.url_term), "Term of Service");

            // Uncomment and handle the privacy policy click event if needed
            // case R.id.privacy_policy:
            //    TermServicePrivatePolicyActivity.launch(getContext(), getContext().getString(R.string.url_private), "Privacy Policy");
            //    break;
        }
    }
}
