package com.seatel.mobilehall.util

import com.seatel.mobilehall.ui.home.model.SimCardPriceModel
import java.text.DecimalFormat


object AppUtils {
    fun decimalFormat(): DecimalFormat {
        var df = DecimalFormat()
        df.isDecimalSeparatorAlwaysShown = true
        df = DecimalFormat("$###.#")
        return df
    }

    fun getTitle(data: SimCardPriceModel): Pair<String, String> {
        return if (data.startPrice < 0 && data.endPrice < 0) {
            Pair("Show All", "")
        } else if (data.startPrice == 0 && data.endPrice == 0) {
            Pair("Normal", "$${data.endPrice}")
        } else if (data.startPrice == 25 && data.endPrice == 25) {
            Pair("One Star", "$${data.endPrice}")
        } else if (data.startPrice == 100 && data.endPrice == 100) {
            Pair("Two Stars", "$${data.endPrice}")
        } else if (data.startPrice == 500 && data.endPrice == 500) {
            Pair("Three Stars", "$${data.endPrice}")
        } else if (data.startPrice == 1000 && data.endPrice == 1000) {
            Pair("Four Stars", "$${data.endPrice}")
        } else if (data.startPrice == 1500 && data.endPrice == 1500) {
            Pair("Five Stars ", "$${data.endPrice}")
        } else {
            Pair("VIP", "above $${data.endPrice}")
        }
    }
}