package com.seatel.mobilehall.ui.yes_member.presenter

import android.content.Context
import com.android.volley.Request
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.seatel.mobilehall.data.network.SeatelJSONArrayRequest
import com.seatel.mobilehall.ui.yes_member.interactor.RewardInteractor
import com.seatel.mobilehall.ui.yes_member.model.RewardModel
import org.json.JSONArray

class RewardPresenter(
    private var mContext: Context,
    private var rewardInteractor: RewardInteractor.View
) : RewardInteractor.Presenter {


    override fun getReward(phoneNumber: String) {
        getRewardRequest(phoneNumber).setOnErrorListener { error ->
            rewardInteractor.responseRewardFail(error)
        }.setOnResponseListener { response ->
            rewardInteractor.responseRewardSucceed(getRewardList(response as JSONArray))
        }.execute()

    }

    private fun getRewardList(response: JSONArray): ArrayList<RewardModel> {
        val gson = Gson()
        val responseString = response.toString()
        val listType = object : TypeToken<ArrayList<RewardModel>>() {}.type
        return gson.fromJson(responseString, listType)
    }

    private fun getRewardRequest(phoneNumber: String): SeatelJSONArrayRequest {
        return object : SeatelJSONArrayRequest(mContext) {

            override fun getFunctionName(): String {
                return "yes-member/reward?phoneNumber=$phoneNumber"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }
        }

    }

}