package com.seatel.mobilehall.ui.yes_member.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.yes_member.interactor.RedeemRewardInteractor
import org.json.JSONObject

class RedeemRewardPresenter(
    private var mContext: Context, private val view: RedeemRewardInteractor.View
) : RedeemRewardInteractor.Presenter {


    override fun redeemReward(phoneNumber: String, reward: String, shop: String) {
        requestRedeemReward(phoneNumber, reward, shop).setOnErrorListener {
            view.responseRedeemRewardFail(it)
        }.setOnResponseListener {
            view.responseRedeemRewardSucceed(getRedeemReward(it as JSONObject))
        }.execute()
    }

    private fun getRedeemReward(response: JSONObject): JSONObject {
        return response
    }

    private fun requestRedeemReward(
        phoneNumber: String, reward: String, shop: String
    ): SeatelJSONObjectRequest {
        return object : SeatelJSONObjectRequest(mContext) {

            override fun onGetBodyRequest(): String {
                val jsonObject = JSONObject()
                jsonObject.put("phoneNumber", phoneNumber)
                jsonObject.put("reward", reward)
                jsonObject.put("shop", shop)

                return jsonObject.toString()
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }

            override fun getFunctionName(): String {
                return "yes-member/redeem-reward"
            }
        }

    }
}