package com.seatel.mobilehall.ui.yes_member.presenter

import android.content.Context
import com.android.volley.Request
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.seatel.mobilehall.data.network.SeatelJSONArrayRequest
import com.seatel.mobilehall.ui.yes_member.interactor.PartnerCategoryInteractor
import com.seatel.mobilehall.ui.yes_member.model.PartnerModelItem
import com.seatel.mobilehall.ui.yes_member.model.PartnerSearchCategoryModel
import org.json.JSONArray

class PartnerCategoryPresenter(
    private var mContext: Context, private var topPartnerInteractor: PartnerCategoryInteractor.View
) : PartnerCategoryInteractor.Presenter {


    override fun onPartnerCategory(category: String) {
        partnerCategroyRequest(category).setOnErrorListener { error ->
            topPartnerInteractor.responsePartnerCategoryFail(error)
        }.setOnResponseListener { response ->
            topPartnerInteractor.responsePartnerCategorySucceed(getPartnerCategoryList(response as JSONArray))
        }.execute()
    }


    private fun getPartnerCategoryList(response: JSONArray): ArrayList<PartnerSearchCategoryModel> {
        val gson = Gson()
        val responseString = response.toString()
        val listType = object : TypeToken<ArrayList<PartnerSearchCategoryModel>>() {}.type
        return gson.fromJson(responseString, listType)
    }

    private fun partnerCategroyRequest(category: String): SeatelJSONArrayRequest {
        return object : SeatelJSONArrayRequest(mContext) {
            override fun getFunctionName(): String {
                return "yes-member/partner?category=$category"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }
    }


}