package com.seatel.mobilehall.ui.yes_member.presenter

import android.content.Context
import com.android.volley.Request
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.seatel.mobilehall.data.network.SeatelJSONArrayRequest
import com.seatel.mobilehall.ui.yes_member.interactor.EarnCoinInteractor
import com.seatel.mobilehall.ui.yes_member.model.EarnCoinModel
import org.json.JSONArray

class EarnCoinPresenter(
    private var mContext: Context, private var earnCoinInteractor: EarnCoinInteractor.View
) : EarnCoinInteractor.Presenter {


    override fun getEarnCoins() {
        getEarnCoinRequest().setOnErrorListener { error ->
            earnCoinInteractor.responseEarnCoinFail(error)
        }.setOnResponseListener { response ->
            earnCoinInteractor.responseEarnCoinSucceed(getEarnCoinList(response as JSONArray))

        }.execute()
    }


    private fun getEarnCoinList(response: JSONArray): ArrayList<EarnCoinModel> {
        val gson = Gson()
        val responseString = response.toString()
        val listType = object : TypeToken<ArrayList<EarnCoinModel>>() {}.type
        return gson.fromJson(responseString, listType)
    }


    private fun getEarnCoinRequest(): SeatelJSONArrayRequest {

        return object : SeatelJSONArrayRequest(mContext) {

            override fun getFunctionName(): String {
                return "yes-member/coin-rating"
            }


            override fun getMethod(): kotlin.Int {
                return Request.Method.GET
            }

        }
    }


}