package com.seatel.mobilehall.ui.yes_member.presenter

import android.content.Context
import com.android.volley.Request
import com.google.gson.Gson
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.yes_member.interactor.EarnCoinHistoryInteractor
import com.seatel.mobilehall.ui.yes_member.model.EarnCoinHistoryModel
import org.json.JSONObject

class EarnCoinHistoryPresenter(
    private var mContext: Context,
    private var earnCoinHistoryInteractor: EarnCoinHistoryInteractor.View
) : EarnCoinHistoryInteractor.Presenter {


    override fun getEarnCoinHistory(phoneNumber: String) {
        getEarnCoinHistoryRequest(phoneNumber).setOnErrorListener {
            earnCoinHistoryInteractor.responseEarnCoinHistoryFail(it)
        }.setOnResponseListener { response ->
            earnCoinHistoryInteractor.responseEarnCoinHistorySucceed(getEarnCoinHistoryList(response as JSONObject)!!)

        }.execute()
    }

    private fun getEarnCoinHistoryList(response: JSONObject): EarnCoinHistoryModel? {
        val gson = Gson()
        val data = gson.fromJson(response.toString(), EarnCoinHistoryModel::class.java)

        return data
    }


    private fun getEarnCoinHistoryRequest(phoneNumber: String): SeatelJSONObjectRequest {
        return object : SeatelJSONObjectRequest(mContext) {

            override fun getMethod(): Int {
                return Request.Method.GET
            }

            override fun getFunctionName(): String {
                return "yes-member/coin-history?phoneNumber=$phoneNumber"
            }

        }
    }


}