package com.seatel.mobilehall.ui.yes_member.interactor

import com.android.volley.VolleyError
import com.seatel.mobilehall.ui.yes_member.model.PartnerCategoryModelItem
import com.seatel.mobilehall.ui.yes_member.model.TopPartnerModelItem
import com.seatel.mobilehall.ui.yes_member.model.YesMemberMainModel

interface MainTopPartnerInteractor {

    interface View {
        fun responseTopPartnerSucceed(topPartnerList: ArrayList<TopPartnerModelItem>)
        fun responseTopPartnerFail(error: VolleyError)

        fun responsePartnerCategorySucceed(partnerCategory: ArrayList<PartnerCategoryModelItem>)
        fun responsePartnerCategoryFail(error: VolleyError)

        fun responseYesMemberMainSucceed(mainModel: YesMemberMainModel)
        fun responseYesMemberMainFail(error: VolleyError)

    }

    interface Presenter {
        fun onTopPartnerData()
        fun onPartnerCategory()
        fun getYesMemberMain(phoneNumber: String)
    }
}