package com.seatel.mobilehall.ui.yes_member.fragment

import android.content.res.ColorStateList
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.core.view.ViewCompat
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.FragmentYesMemberBinding
import com.seatel.mobilehall.ui.base.fragment.BaseFragment
import com.seatel.mobilehall.ui.home.activity.TopUpActivity
import com.seatel.mobilehall.ui.yes_member.activity.CoinActivity
import com.seatel.mobilehall.ui.yes_member.activity.OutLetScanQrActivity
import com.seatel.mobilehall.ui.yes_member.activity.PartnerActivity
import com.seatel.mobilehall.ui.yes_member.activity.YesMemberTermConditionActivity
import com.seatel.mobilehall.ui.yes_member.adapter.MainPartnerCategoryAdapter
import com.seatel.mobilehall.ui.yes_member.adapter.YesMemberAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.MainTopPartnerInteractor
import com.seatel.mobilehall.ui.yes_member.model.PartnerCategoryModelItem
import com.seatel.mobilehall.ui.yes_member.model.TopPartnerModelItem
import com.seatel.mobilehall.ui.yes_member.model.YesMemberMainModel
import com.seatel.mobilehall.ui.yes_member.presenter.MainTopPartnerPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.viewFragmentBinding

class YesMemberFragment : BaseFragment(), MainTopPartnerInteractor.View {


    private lateinit var adapter: YesMemberAdapter
    private lateinit var partnerCategoryAdapter: MainPartnerCategoryAdapter

    private var imgCoin: String? = null
    private var imgBanner: String? = null
    private var coinEarn: String? = null
    private var coinDescription: String? = null


    private val binding by viewFragmentBinding(
        FragmentYesMemberBinding::inflate
    )


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        init()
    }


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?
    ): View? {

        return binding.root
    }

    private fun init() {

        binding.tvNotify.isSelected = true

        MainTopPartnerPresenter(requireContext(), this).getYesMemberMain(getPhoneLogin())
        MainTopPartnerPresenter(requireContext(), this).onTopPartnerData()
        MainTopPartnerPresenter(requireContext(), this).onPartnerCategory()



        binding.btnNotification.setOnClickListener {
            YesMemberTermConditionActivity.launch(requireContext())
        }

        binding.btnPartner.setOnClickListener {
            PartnerActivity.launch(requireContext(), imgBanner!!)
        }

        binding.topUp.setOnClickListener {
            TopUpActivity.lunch(requireContext())
        }
    }


    override fun responseTopPartnerSucceed(topPartnerList: ArrayList<TopPartnerModelItem>) {
        binding.recyclerPartner.layoutManager =
            LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false)
        adapter = YesMemberAdapter(requireContext(), topPartnerList)
        binding.recyclerPartner.adapter = adapter
    }

    override fun responsePartnerCategorySucceed(partnerCategory: ArrayList<PartnerCategoryModelItem>) {
        binding.RecyclerPartnerCategory.layoutManager = GridLayoutManager(context, 2)
        partnerCategoryAdapter = MainPartnerCategoryAdapter(requireContext(), partnerCategory)
        binding.RecyclerPartnerCategory.adapter = partnerCategoryAdapter
    }


    override fun responseTopPartnerFail(error: VolleyError) {
        SeatelAlertDialog.with(requireContext(), SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }

    override fun responsePartnerCategoryFail(error: VolleyError) {
        SeatelAlertDialog.with(requireContext(), SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }

    override fun responseYesMemberMainSucceed(mainModel: YesMemberMainModel) {

        coinEarn = mainModel.coinEarn.toString()
        coinDescription = mainModel.coinDescription
        imgCoin = mainModel.coinBanner
        imgBanner = mainModel.partnerBanner

        binding.tvCoinEarn.text = "Your coins " + mainModel.coinEarn
        binding.tvCoinDescription.text = mainModel.coinDescription
        binding.tvPartnerDescription.text = mainModel.partnerDescription

        val colorRes = if (mainModel.eligiblePartner) R.color.colorPrimary else R.color.colorGray
        val color = ContextCompat.getColor(requireContext(), colorRes)

        ViewCompat.setBackgroundTintList(binding.frameYesPartner, ColorStateList.valueOf(color))
        ViewCompat.setBackgroundTintList(binding.frameYesCoins, ColorStateList.valueOf(color))
        ViewCompat.setBackgroundTintList(binding.qrCodeContainer, ColorStateList.valueOf(color))

        binding.qrCodeContainer.setOnClickListener {
            OutLetScanQrActivity.launch(requireContext())
        }

        binding.btnCoin.setOnClickListener {
            CoinActivity.launch(requireContext(), imgCoin!!, coinEarn!!, coinDescription!!)
        }

    }

    override fun responseYesMemberMainFail(error: VolleyError) {
        SeatelAlertDialog.with(requireContext(), SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }


}