package com.seatel.mobilehall.ui.yes_member.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import coil.load
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ItemSelectShopBinding
import com.seatel.mobilehall.ui.yes_member.model.AvailableShop

class SelectShopAdapter(
    private var mContext: Context,
    private var rewardDetailList: ArrayList<AvailableShop>,
    private var onItemClick: ((AvailableShop) -> Unit)? = null
) : RecyclerView.Adapter<SelectShopAdapter.ViewHolder>() {


    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        fun bind(context: Context, availableShop: AvailableShop) {
            val binding = ItemSelectShopBinding.bind(itemView)

            if (availableShop.isAvailableStock) {
                binding.frameContent.setBackgroundResource(R.drawable.bg_button_round_service)
                binding.btnRedeem.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.colorPrimary
                    )
                )
            } else {
                binding.frameContent.setBackgroundResource(R.drawable.bg_round_gray_section)
                binding.btnRedeem.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.colorGray
                    )
                )
            }

            binding.tvShopName.text = availableShop.name
            if (availableShop.address != null) {
                binding.tvLocation.text = availableShop.address
            }

            binding.ivShopImg.load(availableShop.imageUrl) {
                crossfade(true)
            }

        }

    }

    override fun onCreateViewHolder(
        parent: ViewGroup, viewType: Int
    ): SelectShopAdapter.ViewHolder {
        val binding = ItemSelectShopBinding.inflate(LayoutInflater.from(mContext), parent, false)
        return ViewHolder(binding.root)

    }

    override fun onBindViewHolder(holder: SelectShopAdapter.ViewHolder, position: Int) {
        holder.bind(mContext, rewardDetailList[position])
        holder.itemView.setOnClickListener {
            onItemClick?.invoke(rewardDetailList[position])

        }
    }

    override fun getItemCount(): Int {
        return rewardDetailList.size
    }


}