package com.seatel.mobilehall.ui.yes_member.adapter

import android.content.Context
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import coil.load
import com.seatel.mobilehall.databinding.ItemRewardBinding
import com.seatel.mobilehall.ui.yes_member.activity.SelectShopActivity
import com.seatel.mobilehall.ui.yes_member.model.RewardModel

class RewardAdapter(var mContext: Context, var rewardList: ArrayList<RewardModel>) :
    RecyclerView.Adapter<RewardAdapter.ViewHolder>() {

    class ViewHolder(var binding: ItemRewardBinding) : RecyclerView.ViewHolder(binding.root) {
        fun bind(rewardModel: RewardModel) {

            binding.tvCoin.text = rewardModel.exchangePoint.toString() + " Coins"
            binding.tvTextReward.text = rewardModel.name
            binding.ivReward.load(rewardModel.imageUrl) {
                crossfade(true)
            }

        }
    }

    override fun onCreateViewHolder(
        parent: ViewGroup, viewType: Int
    ): RewardAdapter.ViewHolder {
        val binding = ItemRewardBinding.inflate(
            android.view.LayoutInflater.from(parent.context), parent, false
        )
        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: RewardAdapter.ViewHolder, position: Int) {
        holder.bind(rewardList[position])
        holder.binding.root.setOnClickListener {
            SelectShopActivity.launch(mContext, rewardList[position]._id)
        }

    }

    override fun getItemCount(): Int {
        return rewardList.size
    }


}