package com.seatel.mobilehall.ui.yes_member.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.databinding.ItemPartnerSearchCategoryDetailBinding
import com.seatel.mobilehall.ui.yes_member.activity.OutletLocationActivity
import com.seatel.mobilehall.ui.yes_member.model.PartnerByNameOutlet

class PartnerSearchCategoryDetailAdapter(
    private val context: Context,
    private val partnerByName: ArrayList<PartnerByNameOutlet>
) : RecyclerView.Adapter<PartnerSearchCategoryDetailAdapter.ViewHolder>() {


    class ViewHolder(val binding: ItemPartnerSearchCategoryDetailBinding) :
        RecyclerView.ViewHolder(binding.root) {
        fun binding(context: Context, item: PartnerByNameOutlet) {
            Glide.with(context).load(item.icon).into(binding.ivIcon)
            binding.tvPartnerName.text = item.name
            binding.btnDiscount.text = item.discountDesc
        }

    }


    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): ViewHolder {
        val binding = ItemPartnerSearchCategoryDetailBinding.inflate(
            LayoutInflater.from(parent.context),
            parent,
            false
        )
        return ViewHolder(binding)
    }

    override fun onBindViewHolder(
        holder: ViewHolder,
        position: Int
    ) {

        holder.binding(context, partnerByName[position])
        holder.itemView.setOnClickListener {
            OutletLocationActivity.launch(context, partnerByName[position])
        }

    }

    override fun getItemCount(): Int {
        return partnerByName.size
    }
}