package com.seatel.mobilehall.ui.yes_member.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import coil.load
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.yes_member.activity.PartnerSearchCategoryActivity
import com.seatel.mobilehall.ui.yes_member.model.PartnerCategoryModelItem

class MainPartnerCategoryAdapter(
    private var mContext: Context,
    private var yesPartnerModelItem: ArrayList<PartnerCategoryModelItem>
) : BaseAdapter<MainPartnerCategoryAdapter.ViewHolder>() {

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val title = itemView.findViewById<TextView>(R.id.tv_title)
        val image = itemView.findViewById<ImageView>(R.id.iv_icon)
    }

    override fun onCreateViewHolder(
        parent: ViewGroup, viewType: Int
    ): MainPartnerCategoryAdapter.ViewHolder {
        return ViewHolder(
            LayoutInflater.from(mContext).inflate(R.layout.item_main_partner_category, parent, false)
        )
    }

    override fun onBindViewHolder(holder: MainPartnerCategoryAdapter.ViewHolder, position: Int) {
        val data = yesPartnerModelItem[position]

        holder.image.load(data.icon)
        holder.title.text = data.name

        holder.itemView.setOnClickListener {
            PartnerSearchCategoryActivity.launch(mContext,data.code)
        }
    }

    override fun getItemCount(): Int {
        return yesPartnerModelItem.size
    }
}