package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import coil.load
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityRewardsDetailBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.interactor.RedeemRewardInteractor
import com.seatel.mobilehall.ui.yes_member.presenter.RedeemRewardPresenter
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.dialogannouncement.YesMemberDialog
import org.json.JSONObject

class RewardsDetailActivity : BaseActivity<ActivityRewardsDetailBinding>(),
    RedeemRewardInteractor.View {


    companion object {
        fun launch(
            context: Context,
            imageUrl: String,
            name: String,
            coin: String,
            termCondition: String,
            reward: String,
            shop: String
        ) {
            val intent = Intent(context, RewardsDetailActivity::class.java)
            intent.putExtra("reward_image", imageUrl)
            intent.putExtra("reward_name", name)
            intent.putExtra("reward_coin", coin)
            intent.putExtra("reward_term_condition", termCondition)
            intent.putExtra("reward", reward)
            intent.putExtra("shop", shop)


            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityRewardsDetailBinding {
        return ActivityRewardsDetailBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()

        binding.ivRewardImg.load(intent.getStringExtra("reward_image")) {
            crossfade(true)
        }
        binding.tvRewardName.text = intent.getStringExtra("reward_name")
        binding.tvRewardCoin.text = intent.getStringExtra("reward_coin") + " Coins"
        binding.tvRewardTermConditionDetail.text = intent.getStringExtra("reward_term_condition")

        binding.btnRedeem.setOnClickListener {

            //show dialog

            val dialog = YesMemberDialog(
                this,
                "",
                intent.getStringExtra("reward_name")!!,
                "",
                intent.getStringExtra("reward_coin")!!,
                intent.getStringExtra("reward_image")!!,
                0,
                "OK",
                ""
            ).setPositiveButton(
                "Redeem"
            ) { dialog, which ->
                RedeemRewardPresenter(this, this).redeemReward(
                    getPhoneLogin(),
                    intent.getStringExtra("reward").toString(),
                    intent.getStringExtra("shop").toString()
                )
                dialog.dismiss()
            }.setNegativeButton(
                "Cancel"
            ) { dialog, which ->
                dialog.dismiss()
            }
            dialog.show()


        }

    }


    override fun getStringToolbarTitle(): String? {
        return "Rewards"
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }

    override fun responseRedeemRewardSucceed(rewardDetail: JSONObject) {
        val redeemCode = rewardDetail.optString("redeemCode")
        Log.d("TAG::>>>", "responseRedeemRewardSucceed: $redeemCode")
        val dialog = YesMemberDialog(
            this, "Redeem Successful",
            "Your reward code is",
            redeemCode, "",
            "",
            R.drawable.ic_register_success,
            "Done",
            ""
        ).setPositiveButton("Done") { dialog, which ->
            dialog.dismiss()
        }
        dialog.show()
    }

    override fun responseRedeemRewardFail(error: VolleyError) {

        val dialog = YesMemberDialog(
            this,
            "",
            SeatelUtils.translatForDialog(this, SeatelSuperRequest.getErrorMessageFrom(error)),
            "",
            "",
            "",
            R.drawable.ic_cry_emoji,
            "",
            "Done"
        ).setNegativeButton(
            "Done"
        ) { dialog, which ->
            dialog.dismiss()
        }
        dialog.show()
    }
}