package com.seatel.mobilehall.ui.usage.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.usage.interactor.BilingDetailListInteractor
import com.seatel.mobilehall.ui.usage.model.BilingDetailModel
import com.seatel.mobilehall.util.Constant
import org.json.JSONObject

class BilingDetailListPresenter(
    private var mContext: Context,
    private var mNotificationList: BilingDetailListInteractor.View
) : BilingDetailListInteractor.Presenter {

    private var phoneNumber = ""
    private var typeBiling = ""
    private var startDate = ""
    private var endDate = ""

    fun setPhoneNumber(phoneNumber: String) {
        this.phoneNumber = phoneNumber
    }

    fun setTypeBiling(typeBiling: String) {
        this.typeBiling = typeBiling
    }

    fun setStartDate(startDate: String) {
        this.startDate = startDate
    }

    fun setEndDate(endDate: String) {
        this.endDate = endDate
    }

    override fun onBilingDetailData(offset: Int) {
        getNotificationListRequest(offset).setOnErrorListener { error ->
            mNotificationList.responseBilingFail(error)
        }.setOnResponseListener { response ->
            mNotificationList.responseBilingSucceed(getBilingList(response as JSONObject))
        }.execute()
    }

    private fun getBilingList(response: JSONObject): ArrayList<BilingDetailModel> {
        val bilingListModel = ArrayList<BilingDetailModel>()
        var totalDuration = 0.0
        var totalCost = 0.0
        var totalInternetUsed = 0.0
        var totalSMSUsed = 0.0
        var totalOffNetDuration = 0.0
        var totalInNetDuration = 0.0
        var totalInNetCost = 0.0
        var totalOffNetCost = 0.0


        if (response.has("totalDuration"))
            totalDuration = response.optDouble("totalDuration", 0.0)
        if (response.has("totalCost"))
            totalCost = response.optDouble("totalCost", 0.0)
        if (response.has("totalInternetUsed"))
            totalInternetUsed = response.optDouble("totalInternetUsed", 0.0)
        if (response.has("totalSMSUsed"))
            totalSMSUsed = response.optDouble("totalSMSUsed", 0.0)

        when (typeBiling) {
            Constant.SMS -> {
                totalOffNetDuration = response.optDouble("totalInNetSMSUsed", 0.0)
                totalInNetDuration = response.optDouble("totalOffNetSMSUsed", 0.0)
                totalInNetCost = response.optDouble("totalInNetCost", 0.0)
                totalOffNetCost = response.optDouble("totalOffNetCost", 0.0)
            }
            Constant.VOICE -> {
                totalOffNetDuration = response.optDouble("totalOffNetDuration", 0.0)
                totalInNetDuration = response.optDouble("totalInNetDuration", 0.0)
                totalInNetCost = response.optDouble("totalInNetCost", 0.0)
                totalOffNetCost = response.optDouble("totalOffNetCost", 0.0)
            }
        }

        val data = response.optJSONArray("data")
        for (i in 0 until data.length()) {
            val notificationModel = BilingDetailModel()
            notificationModel.totalCost = totalCost
            notificationModel.totalDuraction = totalDuration
            notificationModel.totalInternetUsed = totalInternetUsed
            notificationModel.totalSMSUsed = totalSMSUsed

            notificationModel.totalOffNetDuration = totalOffNetDuration
            notificationModel.totalInNetDuration = totalInNetDuration
            notificationModel.totalInNetCost = totalInNetCost
            notificationModel.totalOffNetCost = totalOffNetCost

            notificationModel.typeInternet = data.optJSONObject(i).optString("type", "")
            notificationModel.planType = data.optJSONObject(i).optString("planType")

            if (data.optJSONObject(i).has("date"))
                notificationModel.date = data.optJSONObject(i).optString("date")
            if (data.optJSONObject(i).has("to"))
                notificationModel.phone = data.optJSONObject(i).optString("to")
            if (data.optJSONObject(i).has("duration"))
                notificationModel.duration = data.optJSONObject(i).optDouble("duration", 0.0)
            if (data.optJSONObject(i).has("cost"))
                notificationModel.cost = data.optJSONObject(i).optDouble("cost")
            if (data.optJSONObject(i).has("used"))
                notificationModel.used = data.optJSONObject(i).optDouble("used", 0.0)

            bilingListModel.add(notificationModel)
        }

        return bilingListModel

    }

    private fun getNotificationListRequest(offset: Int): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return Constant.BILING + "/$typeBiling?limit=10&offset=$offset&phoneNumber=$phoneNumber&startDate=$startDate&endDate=$endDate"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }
    }

}