package com.seatel.mobilehall.ui.profile.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONArrayRequest
import com.seatel.mobilehall.ui.profile.interactor.RequestSlideAccountUserNameInteractor
import com.seatel.mobilehall.util.Constant
import org.json.JSONArray

class SlideAccountUserNamePresenter(
    private var mContext: Context,
    private var mSlideAccountView: RequestSlideAccountUserNameInteractor.View
) : RequestSlideAccountUserNameInteractor.Presenter {

    override fun onRequestSlideAccount(phoneNumber: String) {
        getSlideAccountRequest(phoneNumber).setOnErrorListener { error ->
            mSlideAccountView.onRequestSlideAccountFailed(error)
        }.setOnResponseListener { response ->
            mSlideAccountView.onRequestSlideAccountSuccess(response as JSONArray)
        }.execute()
    }

    private fun getSlideAccountRequest(phoneNumber: String): SeatelJSONArrayRequest {

        return object : SeatelJSONArrayRequest(mContext) {

            override fun getFunctionName(): String {
                return Constant.SLIDE_PROFILE + "?phoneNumber=$phoneNumber"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }


        }
    }
}