package com.seatel.mobilehall.ui.profile.model

import android.content.Context
import android.os.CountDownTimer
import com.seatel.mobilehall.ui.profile.interactor.CountdownInteractor


class CountdownTimerSingletonClass(context: Context) {
    private var timer: Double = 00.0
    private lateinit var countdownTimer: CountDownTimer
    private lateinit var countdownInteractor: CountdownInteractor

    companion object {
        @Volatile
        private var instance: CountdownTimerSingletonClass? = null

        fun getInstance(context: Context): CountdownTimerSingletonClass? {
            if (instance == null)  // NOT thread safe!
                instance = CountdownTimerSingletonClass(context)

            return instance
        }

        fun clear() {
            instance = null
        }
    }

    fun getCountdownTimer(): Double {
        return timer
    }

    fun setCountdownInteractor(countdownInteractor: CountdownInteractor) {
        this.countdownInteractor = countdownInteractor
    }

    fun initTimer() {

    }

    fun startTimer(timer: Double) {
        this.timer = timer
        object : CountDownTimer(timer.toLong(), 1000) {

            override fun onTick(millisUntilFinished: Long) {
                this@CountdownTimerSingletonClass.timer = (millisUntilFinished / 1000).toDouble()
                this@CountdownTimerSingletonClass.countdownInteractor.timer(this@CountdownTimerSingletonClass.timer)
            }

            override fun onFinish() {
                this@CountdownTimerSingletonClass.timer = 0.0
            }

        }.start()
    }


}