package com.seatel.mobilehall.ui.profile.fragment


import android.annotation.SuppressLint
import android.app.Dialog
import android.view.View
import android.widget.Button
import android.widget.LinearLayout
import androidx.coordinatorlayout.widget.CoordinatorLayout
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.profile.interactor.BottomSheetInteractor


@Suppress("DEPRECATION")
open class BottomSheetFragment : BottomSheetDialogFragment() {
    private var mParams: CoordinatorLayout.LayoutParams? = null
    private lateinit var bottomSheetBehavior: BottomSheetBehavior<*>
    private lateinit var mBottomSheetView: BottomSheetInteractor.View

    private val mBottomSheetBehaviorCallback = object : BottomSheetBehavior.BottomSheetCallback() {

        override fun onStateChanged(bottomSheet: View, newState: Int) {
            if (newState == BottomSheetBehavior.STATE_HIDDEN)
                dismiss()
        }

        override fun onSlide(bottomSheet: View, slideOffset: Float) {}
    }

    fun setBottomSheetView(bottomSheetView: BottomSheetInteractor.View) {
        this.mBottomSheetView = bottomSheetView
    }

//    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,
//                              savedInstanceState: Bundle?): View? {
//        // Inflate the layout for this fragment
//        return inflater.inflate(R.layout.fragment_bottom_sheet, container, false)
//    }

    @SuppressLint("RestrictedApi")
    override fun setupDialog(dialog: Dialog, style: Int) {

        super.setupDialog(dialog, style)
        val view = View.inflate(context, R.layout.dialog_choose_image, null)
        dialog.setContentView(view)

        if (mParams == null) {
            mParams = (view.parent as View).layoutParams as CoordinatorLayout.LayoutParams
        }

        val behavior = mParams!!.behavior
        (view.parent as View).setBackgroundColor(resources.getColor(android.R.color.transparent))
        bottomSheetBehavior = BottomSheetBehavior.from<View>(view.findViewById(R.id.root_layout) )


        if (behavior != null && behavior is BottomSheetBehavior<*>) {
            bottomSheetBehavior.setBottomSheetCallback(mBottomSheetBehaviorCallback)
        }

        view.findViewById<LinearLayout>(R.id.parent_camera) .setOnClickListener { mBottomSheetView.onCameraClicked() }
        view.findViewById<LinearLayout>(R.id.parent_gallery) .setOnClickListener { mBottomSheetView.onGalleryClicked() }

        view.findViewById<Button>(R.id.button_cancel) .setOnClickListener {
            bottomSheetBehavior.state = BottomSheetBehavior.STATE_HIDDEN
        }
    }


}