package com.seatel.mobilehall.ui.profile.adapter;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.seatel.mobilehall.R;
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter;
import com.seatel.mobilehall.ui.home.activity.TopUpActivity;
import com.seatel.mobilehall.ui.packages.RoamingActivity;
import com.seatel.mobilehall.ui.profile.activity.GetMoreDataActivity;
import com.seatel.mobilehall.ui.profile.interactor.SubRowListValuePackInteractor;
import com.seatel.mobilehall.ui.profile.model.BalancesPostPaidModel;
import com.seatel.mobilehall.ui.profile.model.DataPlansModel;
import com.seatel.mobilehall.ui.profile.model.InternetPackListModel;
import com.seatel.mobilehall.ui.profile.model.MySubscriptionModel;
import com.seatel.mobilehall.util.Constant;
import com.seatel.mobilehall.util.SeatelUtils;
import com.seatel.mobilehall.util.circleprogress.ArcProgress;
import com.seatel.mobilehall.util.customview.CustomTextView;
import com.seatel.mobilehall.util.customview.InternetPackDetailView;
import com.seatel.mobilehall.util.customview.ListSubscriptionPostPaidCircleBalancesView;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;

public class MySubscriptionAdapter extends BaseAdapter<RecyclerView.ViewHolder> {

    private final Context mContext;
    private final MySubscriptionModel mMySubscriptionModel;
    private final Boolean isPostPaid;
    private boolean isTouristPassAccount;
    private String strLangCode;

    private final int ONE_PLAN_TYPE = 0;
    private final int POSTPAID_TYPE = -1;
    private final int TOURIST_PASS_TYPE = -2;

    public MySubscriptionAdapter(Context context, MySubscriptionModel mySubscriptionModel, Boolean isPostPaid) {
        this.mContext = context;
        this.mMySubscriptionModel = mySubscriptionModel;
        this.isPostPaid = isPostPaid;
        checkIsTouristPassType();
    }

    private void checkIsTouristPassType() {
        isTouristPassAccount = mMySubscriptionModel.getPlanCode().contains("Tourist_PASS");
    }


    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {

        if (viewType == ONE_PLAN_TYPE) {
            return new OnePlanHolder(LayoutInflater.from(mContext).inflate(R.layout.item_my_subscription_one_plan, parent, false));
        } else if (viewType == TOURIST_PASS_TYPE) {
            View view = LayoutInflater.from(mContext).inflate(R.layout.item_my_subscription_tourist_pass, parent, false);
            return new TouristPassHolder(view);
        } else if (viewType == POSTPAID_TYPE) {
            return new PostPaidHolder(LayoutInflater.from(mContext).inflate(R.layout.item_my_subscription_post_paid, parent, false));
        } else {
            return new DatPackHolder(LayoutInflater.from(mContext).inflate(R.layout.item_my_subscription_data_pack, parent, false));
        }


    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (getLastPosition() == -1) {
            holder.itemView.setVisibility(View.INVISIBLE);
        }
        setAnimations(holder.itemView, position);

        if (holder instanceof OnePlanHolder) {
            ((OnePlanHolder) holder).bind(mMySubscriptionModel);
        }
        if (holder instanceof TouristPassHolder) {
            ((TouristPassHolder) holder).bind(mMySubscriptionModel);
        }
        if (holder instanceof PostPaidHolder) {
            ((PostPaidHolder) holder).bind(mMySubscriptionModel);
        }
        if (holder instanceof DatPackHolder) {
            ((DatPackHolder) holder).bind(Objects.requireNonNull(mMySubscriptionModel.getDataPlans()).get(position - 1));
        }


    }

    @Override
    public int getItemCount() {
        return ((mMySubscriptionModel.getDataPlans() != null) ? mMySubscriptionModel.getDataPlans().size() + 1 : 1);
    }

    @Override
    public int getItemViewType(int position) {
        if (position == 0) {
            return isPostPaid ? POSTPAID_TYPE : (isTouristPassAccount && mMySubscriptionModel.getUseGaugeText() ? TOURIST_PASS_TYPE : ONE_PLAN_TYPE);
        }
        return position;
    }

    class OnePlanHolder extends RecyclerView.ViewHolder {

        private final TextView onePlanTitle;
        private final TextView subDate;
        private final TextView expireDate;
        private final TextView balance;
        private final TextView buttonBuy;
        private final TextView txtVoice;
        private final TextView txtSms;
        private final ImageView imageViewOnePlan;
        private final LinearLayout viewBalnacesPostpaid;

        public OnePlanHolder(View itemView) {
            super(itemView);
            imageViewOnePlan = itemView.findViewById(R.id.image_view_plan);
            onePlanTitle = itemView.findViewById(R.id.text_view_one_plan_title);
            subDate = itemView.findViewById(R.id.text_view_sub_date);
            expireDate = itemView.findViewById(R.id.text_view_expire_date);
            balance = itemView.findViewById(R.id.text_view_balance);
            buttonBuy = itemView.findViewById(R.id.button_buy);
            viewBalnacesPostpaid = itemView.findViewById(R.id.view_balances_postpaid);
            txtVoice = itemView.findViewById(R.id.ctv_voice);
            txtSms = itemView.findViewById(R.id.ctv_sms);
            buttonBuy.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    TopUpActivity.Companion.lunch(mContext);
                }
            });
        }

        public void bind(MySubscriptionModel mySubscriptionModel) {
            txtVoice.setText(mContext.getResources().getString(R.string.voice));
            if (mySubscriptionModel.getPlanCode().contains("Tourist_PASS")) {
                txtVoice.setText(mContext.getResources().getString(R.string.voice_tourist));
                txtSms.setText(mContext.getResources().getString(R.string.sms));
                txtSms.setText(mContext.getResources().getString(R.string.sms_tourist));
            }

            if (mySubscriptionModel.getPlanCode().contains("Fortune_Plan_Subsplan"))
                buttonBuy.setText(R.string.top_up);
            else
                buttonBuy.setText(R.string.buy_more);
            if (TextUtils.isEmpty(mySubscriptionModel.getPlanIcon()) || mySubscriptionModel.getPlanIcon().equalsIgnoreCase("null"))
                imageViewOnePlan.setVisibility(View.GONE);
            else {
                imageViewOnePlan.setVisibility(View.VISIBLE);
                Glide.with(mContext).load(mySubscriptionModel.getPlanIcon()).into(imageViewOnePlan);
            }

            if (mySubscriptionModel.getPlanCode().toLowerCase().contains(Constant.SEA_REGULAR.toLowerCase()) ||
                    mySubscriptionModel.getPlanCode().toLowerCase().contains("Tourist_PASS".toLowerCase())) {
                buttonBuy.setText(R.string.top_up);
            }

            viewBalnacesPostpaid.setVisibility(View.GONE);

            if (mySubscriptionModel.getPlanCode().toLowerCase().
                    contains(Constant.ONE_SUB_PLAN_CODE.toLowerCase())) {
                buttonBuy.setText(R.string.top_up);
            }

            if (mMySubscriptionModel.getPlanCode().toLowerCase().contains(Constant.AIRLINE_PLAN.toLowerCase())) {
                buttonBuy.setText(R.string.top_up);
            }
            if (mMySubscriptionModel.getPlanCode().toLowerCase().contains(Constant.ONE_PLAN_IFA.toLowerCase())) {
                buttonBuy.setText(R.string.top_up);
            }
            if (mMySubscriptionModel.getPlanCode().toLowerCase().contains(Constant.TOURIST_PASS.toLowerCase())) {
                buttonBuy.setText(R.string.top_up);
            }

            onePlanTitle.setText(mySubscriptionModel.getPlanName());

            subDate.setText(SeatelUtils.Companion.getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                    mySubscriptionModel.getSubscribedDate()));

            expireDate.setText(SeatelUtils.Companion.getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                    mySubscriptionModel.getExpiredDate()));

            balance.setText(mySubscriptionModel.getBalance().equals("0") ?
                    "$0" : "$" + String.format("%.2f", Float.parseFloat(mySubscriptionModel.getBalance()))
            );

            if (!mySubscriptionModel.getShowUnlimitedVoiceAndSMS()) {
                itemView.findViewById(R.id.relative_layout_voice_call).setVisibility(View.GONE);
                itemView.findViewById(R.id.relative_layout_sms).setVisibility(View.GONE);
            }
        }
    }

    class TouristPassHolder extends RecyclerView.ViewHolder {

        private final TextView title;
        private final TextView subDate;
        private final TextView expDate;
        private final TextView expDateInternet;
        private final TextView balance;
        private final ArcProgress dataLeft;
        private final ImageView imageViewDataPack;
        private final TextView buttonBuy;
        private final TextView txtVoice;
        private final TextView txtSms;
        private final View viewSubscribe;
        private final View viewBalanceSubscribe;
        private final View viewExpiredProgress;
        private final FrameLayout layoutProgressRun;


        public TouristPassHolder(View itemView) {
            super(itemView);

            title = itemView.findViewById(R.id.text_view_data_pack_title);
            subDate = itemView.findViewById(R.id.text_view_sub_date);
            expDate = itemView.findViewById(R.id.text_view_exp_date);
            expDateInternet = itemView.findViewById(R.id.text_view_internet_exp_date);
            balance = itemView.findViewById(R.id.text_view_balance);
            dataLeft = itemView.findViewById(R.id.view_progress_bar);
            imageViewDataPack = itemView.findViewById(R.id.image_view_plan);
            buttonBuy = itemView.findViewById(R.id.button_buy);
            viewSubscribe = itemView.findViewById(R.id.linear_layout_one_plan_detail);
            viewBalanceSubscribe = itemView.findViewById(R.id.linear_layout_one_plan_detail_below);
            layoutProgressRun = itemView.findViewById(R.id.layout_progress_bar);
            viewExpiredProgress = itemView.findViewById(R.id.view_expired_internet);
            txtVoice = itemView.findViewById(R.id.ctv_voice);
            txtSms = itemView.findViewById(R.id.ctv_sms);

            buttonBuy.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    TopUpActivity.Companion.lunch(mContext);
                }
            });
        }

        @SuppressLint("SetTextI18n")
        public void bind(MySubscriptionModel dataPlansModel) {

            if (TextUtils.isEmpty(dataPlansModel.getPlanIcon()) || dataPlansModel.getPlanIcon().equalsIgnoreCase("null"))
                imageViewDataPack.setVisibility(View.GONE);
            else {
                imageViewDataPack.setVisibility(View.VISIBLE);
                Glide.with(mContext).load(dataPlansModel.getPlanIcon()).into(imageViewDataPack);
            }

            balance.setText(dataPlansModel.getBalance().equals("0") ?
                    "$0" : "$" + Float.parseFloat(dataPlansModel.getBalance())
            );

            subDate.setText(SeatelUtils.Companion
                    .getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                            dataPlansModel.getSubscribedDate()));
            expDate.setText(SeatelUtils.Companion
                    .getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                            dataPlansModel.getExpiredDate()));
            expDateInternet.setText(SeatelUtils.Companion
                    .getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                            dataPlansModel.getTouristExpiredDate()));

            if (!dataPlansModel.getShowBalance()) {
                viewExpiredProgress.setVisibility(View.GONE);
                viewBalanceSubscribe.setVisibility(View.GONE);

                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) viewSubscribe.getLayoutParams();
                layoutParams.setMargins(0, 75, 0, 0);
                viewSubscribe.setLayoutParams(layoutParams);

                expDate.setText(SeatelUtils.Companion
                        .getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                                dataPlansModel.getTouristExpiredDate()));
                subDate.setText(SeatelUtils.Companion
                        .getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                                dataPlansModel.getTouristSubscribedDate()));
            }

            title.setText(dataPlansModel.getPlanName());

            float remainProgress = 0f;
            if (isTouristPassAccount) { //dataPlansModel.getUseGaugeText()
                remainProgress = 100f;
                dataLeft.setMax(100);
                dataLeft.setDataLeftText("");
                dataLeft.setUnlimtedText(SeatelUtils.translatForDialog(mContext, dataPlansModel.getMainGaugeText()));
                dataLeft.setUnlimitedTextSize(mContext.getResources().getDimension(R.dimen.unlimited_text_size_subscription));
            }
            long duration = 1500;
            if (remainProgress == dataLeft.getMax())
                duration = 800;
            final long finalDuration = duration;
            final float finalRemainProgress = remainProgress;
            final Handler delay = new Handler();
            delay.postDelayed(new Runnable() {
                @Override
                public void run() {
                    ObjectAnimator progressAnimator = ObjectAnimator.ofFloat(dataLeft, "progress", 0F, finalRemainProgress);
                    progressAnimator.setDuration(finalDuration);
                    progressAnimator.setInterpolator(new DecelerateInterpolator());
                    progressAnimator.start();
                    delay.removeCallbacks(this);
                }
            }, 1000);

        }
    }

    class PostPaidHolder extends RecyclerView.ViewHolder {

        private final TextView textFake1;
        private final TextView textFake2;
        private final TextView textFake3;
        private final TextView title;
        private final TextView titleBill;
        private final TextView billDate;
        private final TextView paymentDate;
        private final ArcProgress dataLeft;
        private final ImageView imageViewDataPack;
        private final ImageView imageArrow;
        private final TextView buttonBuy;

        private final LinearLayout viewBalnacesPostpaid;
        private final LinearLayout viewScrollBalnacesPostpaid;
        private final View ViewArrowShowList;
        private final View topupViewText;
        private int heighViewList;
        private ValueAnimator animMove;
        private int moreSpaceBottom;
        private boolean isKhmerLang;

        public PostPaidHolder(View itemView) {
            super(itemView);

            textFake1 = itemView.findViewById(R.id.text_fack);
            textFake2 = itemView.findViewById(R.id.text_fack_2);
            textFake3 = itemView.findViewById(R.id.text_fack_3);
            title = itemView.findViewById(R.id.text_view_data_pack_title);
            titleBill = itemView.findViewById(R.id.text_title_sub_bill);
            billDate = itemView.findViewById(R.id.text_view_sub_date);
            paymentDate = itemView.findViewById(R.id.text_view_exp_date);
            dataLeft = itemView.findViewById(R.id.view_progress_bar);
            imageViewDataPack = itemView.findViewById(R.id.image_data_pack);
            imageArrow = itemView.findViewById(R.id.img_arrow);
            buttonBuy = itemView.findViewById(R.id.button_buy);

            viewBalnacesPostpaid = itemView.findViewById(R.id.view_balances_postpaid);
            viewScrollBalnacesPostpaid = itemView.findViewById(R.id.view_keep_scroll);
            ViewArrowShowList = itemView.findViewById(R.id.view_show_list_data_PostPaid);
            topupViewText = itemView.findViewById(R.id.view_key_text_footer);

            buttonBuy.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    TopUpActivity.Companion.lunch(mContext);
                }
            });

            strLangCode = SeatelUtils.Companion.getLangaugeCode(mContext);

            moreSpaceBottom = 0;
            isKhmerLang = false;
            if (TextUtils.equals(strLangCode.toLowerCase(), "km")) {
                moreSpaceBottom = 25;
                isKhmerLang = true;
            }
            setTextFakeContent(isKhmerLang);
        }

        private void setTextFakeContent(boolean isKhmer) {
            if (isKhmer) {
                textFake1.setText(mContext.getString(R.string.credit_limit));
                textFake2.setText(mContext.getString(R.string.credit_limit));
                textFake3.setText(mContext.getString(R.string.credit_limit));
            } else {
                textFake1.setText(mContext.getString(R.string.top_up_balance_title));
                textFake2.setText(mContext.getString(R.string.top_up_balance_title));
                textFake3.setText(mContext.getString(R.string.top_up_balance_title));
            }
        }

        private void hideShowList(final boolean isShow) {
            if (isShow) {
                imageArrow.setRotation(270f);
                imageArrow.setPaddingRelative(10, 0, 0, 0);
                animMove = ValueAnimator.ofInt(0, heighViewList);
            } else {
                imageArrow.setRotation(180f);
                imageArrow.setPaddingRelative(0, 0, 0, 0);
                animMove = ValueAnimator.ofInt(heighViewList, 0);
            }
            animMove.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
                @Override
                public void onAnimationUpdate(ValueAnimator animation) {
                    int val = (Integer) animation.getAnimatedValue();
                    ViewGroup.LayoutParams layoutParams = viewScrollBalnacesPostpaid.getLayoutParams();
                    layoutParams.height = val;
                    viewScrollBalnacesPostpaid.setLayoutParams(layoutParams);
                }
            });
            animMove.addListener(new Animator.AnimatorListener() {
                @Override
                public void onAnimationStart(Animator animation) {
                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    if (!isShow) {
                        viewScrollBalnacesPostpaid.setVisibility(View.GONE);
                        imageArrow.setRotation(180f);
                    } else {
                        imageArrow.setRotation(270f);
                    }
                    ViewArrowShowList.setClickable(true);
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                }

                @Override
                public void onAnimationRepeat(Animator animation) {
                }
            });
            animMove.setDuration(500);
            animMove.setInterpolator(new AccelerateDecelerateInterpolator());
            animMove.start();
        }

        @SuppressLint("SetTextI18n")
        public void bind(final MySubscriptionModel dataPlansModel) {
            moreSpaceBottom = 0;
            isKhmerLang = false;
            if (TextUtils.equals(strLangCode.toLowerCase(), "km")) {
                moreSpaceBottom = 45;
                isKhmerLang = true;
            }

            setTextFakeContent(isKhmerLang);
            viewBalnacesPostpaid.setTag("hide");
            viewScrollBalnacesPostpaid.setVisibility(View.GONE);
            if (dataPlansModel.getBalancesPostPaid().isEmpty())
                ViewArrowShowList.setVisibility(View.GONE);

            ViewArrowShowList.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    ViewArrowShowList.setClickable(false);
                    if (!dataPlansModel.getBalancesPostPaid().isEmpty()) {
                        String tag = viewBalnacesPostpaid.getTag().toString();
                        if (!TextUtils.equals(tag, "show")) {
                            for (BalancesPostPaidModel data : dataPlansModel.getBalancesPostPaid()) {

                                //hide credit limit
                                if (!Objects.requireNonNull(data.getName()).contains("Credit Limit")) {
                                    ListSubscriptionPostPaidCircleBalancesView balancePostPaid = new ListSubscriptionPostPaidCircleBalancesView(mContext);
                                    balancePostPaid.setDataDisplay(data, data.getTopupBalanceRow());
                                    viewBalnacesPostpaid.addView(balancePostPaid);
                                }
                            }

                            viewScrollBalnacesPostpaid.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                            topupViewText.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                            heighViewList = viewScrollBalnacesPostpaid.getMeasuredHeight() + topupViewText.getMeasuredHeight() / 2 + moreSpaceBottom;
                        }
                        if (viewScrollBalnacesPostpaid.getVisibility() != View.VISIBLE) {
                            viewScrollBalnacesPostpaid.setVisibility(View.VISIBLE);
                            hideShowList(true);
                            viewBalnacesPostpaid.setTag("show");
                        } else {
                            hideShowList(false);
                        }
                    } else {
                        ViewArrowShowList.setClickable(true);
                    }
                }
            });

            if (TextUtils.isEmpty(dataPlansModel.getPlanIcon()) || dataPlansModel.getPlanIcon().equalsIgnoreCase("null"))
                imageViewDataPack.setVisibility(View.GONE);
            else {
                imageViewDataPack.setVisibility(View.VISIBLE);
                Glide.with(mContext).load(dataPlansModel.getPlanIcon()).into(imageViewDataPack);
            }
            title.setText(dataPlansModel.getPlanName());
            titleBill.setText(dataPlansModel.getName());

            billDate.setText(SeatelUtils
                    .Companion.getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                            dataPlansModel.getSubscribedDate()));

            paymentDate.setText(SeatelUtils
                    .Companion.getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                            dataPlansModel.getExpiredDate()));


            double remainP = dataPlansModel.getUsedBalance();
            double totalP = dataPlansModel.getTotalBalance();
            float remainProgress = (float) remainP;
            float totalProgress = (float) totalP;
            dataLeft.setMax(totalProgress);
            dataLeft.setIsShowDollar(true);
            dataLeft.setTextSize(80);
            //  dataLeft.setIsShowdollarInSubscription(true);
            long duration = 1500;
            if (remainProgress == dataLeft.getMax())
                duration = 800;
            final long finalDuration = duration;
            final float finalRemainProgress = remainProgress;
            final Handler delay = new Handler();
            delay.postDelayed(new Runnable() {
                @Override
                public void run() {
                    ObjectAnimator progressAnimator = ObjectAnimator.ofFloat(dataLeft, "progress", 0F, finalRemainProgress);
                    progressAnimator.setDuration(finalDuration);
                    progressAnimator.setInterpolator(new DecelerateInterpolator());
                    //progressAnimator.setInterpolator(new LinearInterpolator());
                    progressAnimator.start();
                    delay.removeCallbacks(this);
                }
            }, 1000);

        }
    }

    class DatPackHolder extends RecyclerView.ViewHolder implements SubRowListValuePackInteractor {

        private final TextView title;
        private final TextView internetLeftTem;
        private final TextView subDate;
        private final TextView expDate;
        private final ArcProgress dataLeft;
        private final TextView mTotalData;
        private final TextView mDataSize;
        private final TextView mTvTotalDisplay;
        private final ImageView imageViewDataPack;
        private final ImageView ivOnePlan;
        private final ImageView imageArrow;
        private final TextView buttonBuy;
        private final View viewTotal;
        private final View ViewArrowShowList;
        private final ScrollView scrollViewKeepListInternetPack;
        private final LinearLayout viewListContent;
        private final RelativeLayout lnTotalData;
        private ValueAnimator animMove;
        private int heighViewList;
        private int heighViewSubValuePackList;
        private boolean isSubListShow = false;
        private final SubRowListValuePackInteractor actionSubList;

        DatPackHolder(View itemView) {
            super(itemView);

            internetLeftTem = itemView.findViewById(R.id.txt_data_used);
            title = itemView.findViewById(R.id.text_view_data_pack_title);
            subDate = itemView.findViewById(R.id.text_view_sub_date);
            expDate = itemView.findViewById(R.id.text_view_exp_date);
            dataLeft = itemView.findViewById(R.id.view_progress_bar);
            mTotalData = itemView.findViewById(R.id.txt_data_total);
            mDataSize = itemView.findViewById(R.id.text_view_size);
            mTvTotalDisplay = itemView.findViewById(R.id.tv_total_show);
            lnTotalData = itemView.findViewById(R.id.lnTotalDataView);
            imageViewDataPack = itemView.findViewById(R.id.image_data_pack);
            ivOnePlan = itemView.findViewById(R.id.image_one_plan);
            imageArrow = itemView.findViewById(R.id.img_arrow);
            buttonBuy = itemView.findViewById(R.id.button_buy);
            viewTotal = itemView.findViewById(R.id.layout_global);
            ViewArrowShowList = itemView.findViewById(R.id.view_show_list_data);
            scrollViewKeepListInternetPack = itemView.findViewById(R.id.scroll_list_internet_pack);
            viewListContent = itemView.findViewById(R.id.view_list_content_internet);

            actionSubList = this;

        }


        @SuppressLint("SetTextI18n")
        public void bind(final DataPlansModel dataPlansModel) {
            boolean isValuePackRow = false;

            buttonBuy.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (dataPlansModel.getName().equals("China Mainland Pack")) {
                        RoamingActivity.Companion.lunch(mContext);
                    } else
                        GetMoreDataActivity.Companion.lunch(mContext);
                }
            });

            if (!dataPlansModel.getBuyMore()) {
                buttonBuy.setVisibility(View.GONE);
            }

            if (TextUtils.isEmpty(dataPlansModel.getIcon()) || dataPlansModel.getIcon().equalsIgnoreCase("null"))
                imageViewDataPack.setVisibility(View.GONE);
            else {
                imageViewDataPack.setVisibility(View.VISIBLE);
                Glide.with(mContext).load(dataPlansModel.getIcon()).into(imageViewDataPack);
            }
            if ((dataPlansModel.getName().equalsIgnoreCase(Constant.INTERNET_BENEFIT))) {
                buttonBuy.setVisibility(View.GONE);
            }
            if (dataPlansModel.getCode().contains("CorpPlan25")) {
                buttonBuy.setVisibility(View.GONE);
            }
            if (mMySubscriptionModel.getPlanCode().toLowerCase().contains(Constant.AIRLINE_PLAN.toLowerCase())) {
                buttonBuy.setVisibility(View.GONE);
            }

            Log.d("TAG::>>>", "bind: " + dataPlansModel.getName());

            title.setText(dataPlansModel.getName());
            subDate.setText(SeatelUtils
                    .Companion.getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                            dataPlansModel.getSubscribedDate()));

            expDate.setText(SeatelUtils
                    .Companion.getDateTime("yyyy-MM-dd", Constant.DATE_FORMAT_DISPLAY,
                            dataPlansModel.getExpiredDate()));


            // Data Left Section
            Double totalData = SeatelUtils.Companion.convertMbToGb(dataPlansModel.getTotalData());
            Double totalRemain = SeatelUtils.Companion.convertMbToGb(dataPlansModel.getRemainingData());

            String typeDataTotal = SeatelUtils.Companion.getTypeData(dataPlansModel.getTotalData());
            String typeDataRemain = SeatelUtils.Companion.getTypeData(dataPlansModel.getRemainingData());

            dataLeft.setSuffixText(typeDataRemain);
            dataLeft.setDataLeftText(internetLeftTem.getText().toString());

            float remainProgress = 0f;

            if (TextUtils.equals(dataPlansModel.getCode().toLowerCase(), "value-pack")) {
                isValuePackRow = true;
                totalData = dataPlansModel.getTotalValue();
                remainProgress = dataPlansModel.getRemainingValue().floatValue();
                dataLeft.setIsShowDollar(true);
                dataLeft.setTextSizeDeduct(10f);
                dataLeft.setSuffixText("");
                dataLeft.setDataLeftText(SeatelUtils.translatForDialog(itemView.getContext(), itemView.getContext().getString(R.string.remaining_balance)));
                mTvTotalDisplay.setText("(" + SeatelUtils.translatForDialog(itemView.getContext(), "Total Amount") + ")");

                //   dataLeft.setMax(totalData.intValue());

                DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.getDefault());
                otherSymbols.setDecimalSeparator('.');
                otherSymbols.setGroupingSeparator(',');
                DecimalFormat df = new DecimalFormat("$###,###.##", otherSymbols);
                mTotalData.setText(df.format(totalData));
                mDataSize.setText("");
            } else if (TextUtils.equals(dataPlansModel.getCode().toLowerCase(), "innet-sms")) {
                totalData = dataPlansModel.getTotalValue();
                remainProgress = dataPlansModel.getRemainingData().floatValue();

                dataLeft.setSuffixText(SeatelUtils.translatForDialog(mContext, "SMS"));
                dataLeft.setDataLeftText(SeatelUtils.translatForDialog(mContext, "On Net SMS Left"));
                dataLeft.setMax(totalData.intValue());
                mTotalData.setText(totalData.toString());
                mTvTotalDisplay.setText("(" + SeatelUtils.translatForDialog(itemView.getContext(), "Total SMS") + ")");
                mDataSize.setText(SeatelUtils.translatForDialog(mContext, "SMS"));

            } else if (TextUtils.equals(dataPlansModel.getCode().toLowerCase(), "innet-voice")) {
                totalData = dataPlansModel.getTotalValue();
                remainProgress = dataPlansModel.getRemainingData().floatValue();
                dataLeft.setSuffixText(SeatelUtils.translatForDialog(mContext, "Min"));
                dataLeft.setDataLeftText(SeatelUtils.translatForDialog(mContext, "On Net Call Left"));
                dataLeft.setMax(totalData.intValue());
                mTotalData.setText(totalData.toString());
                mTvTotalDisplay.setText("(" + SeatelUtils.translatForDialog(itemView.getContext(), "Total Minutes") + ")");
                mDataSize.setText(SeatelUtils.translatForDialog(mContext, "Min"));
            } else if (TextUtils.equals(dataPlansModel.getCode().toLowerCase(), "outnet-voice")) {
                totalData = dataPlansModel.getTotalValue();
                remainProgress = dataPlansModel.getRemainingData().floatValue();
                dataLeft.setSuffixText(SeatelUtils.translatForDialog(mContext, "Min"));
                dataLeft.setDataLeftText(SeatelUtils.translatForDialog(mContext, "Out Net Call Left"));
                dataLeft.setMax(totalData.intValue());
                mTotalData.setText(totalData.toString());
                mTvTotalDisplay.setText("(" + SeatelUtils.translatForDialog(itemView.getContext(), "Total Minutes") + ")");
                mDataSize.setText(SeatelUtils.translatForDialog(mContext, "Min"));
            } else {

                if (totalData != null) {
                    totalData = Double.parseDouble(String.format("%.2f", totalData).replace(",", "."));
                }

                if (totalRemain != null) {
                    totalRemain = Double.parseDouble(String.format("%.2f", totalRemain).replace(",", "."));
                }

                if (dataPlansModel.getUseGaugeText()) {
                    remainProgress = 100f;
                    dataLeft.setMax(100);
                    dataLeft.setDataLeftText("");
                    dataLeft.setUnlimtedText(SeatelUtils.translatForDialog(mContext, dataPlansModel.getMainGaugeText()));
                    dataLeft.setUnlimitedTextSize(mContext.getResources().getDimension(R.dimen.unlimited_text_size_subscription));
                    viewTotal.setVisibility(View.INVISIBLE);
                } else {
                    Double totalMax = SeatelUtils.Companion.convertMbToGb(totalData);
                    String dataDisplay;
                    if (TextUtils.equals(typeDataTotal.toUpperCase(), "MB")) {
                        int totalInt = SeatelUtils.Companion.roundInteger(mContext, totalRemain.intValue());
                        remainProgress = (float) totalInt;
                        dataDisplay = "" + SeatelUtils.Companion.roundInteger(mContext, totalData.intValue());
                        dataLeft.setMax(SeatelUtils.Companion.roundInteger(mContext, totalData.intValue()));
                    } else {
                        dataDisplay = "" + totalData;
                        int temp = totalData.intValue();
                        if (totalData.equals(Double.valueOf(temp))) {
                            dataDisplay = "" + totalData.intValue();
                        }
                        if (TextUtils.equals(typeDataRemain.toUpperCase(), "MB")) {
                            Double totalMB = SeatelUtils.Companion.convertGbToMb(totalData);
                            totalMB = Double.parseDouble(String.format("%.2f", totalMB).replace(",", "."));
                            dataLeft.setMax(totalMB.intValue());
                            remainProgress = totalRemain.floatValue();
                        } else if (TextUtils.equals(typeDataRemain.toUpperCase(), "TB")) {
                            totalData = SeatelUtils.Companion.convertMbToTb(dataPlansModel.getTotalData());
                            totalData = Double.parseDouble(String.format("%.2f", totalData).replace(",", "."));
                            dataLeft.setMax(totalData.floatValue());
                            dataDisplay = "" + totalData;
                            temp = totalData.intValue();
                            if (totalData.equals(Double.valueOf(temp))) {
                                dataDisplay = "" + temp;
                            }
                            totalRemain = SeatelUtils.Companion.convertMbToTb(dataPlansModel.getRemainingData());
                            if (totalRemain != null) {
                                totalRemain = Double.parseDouble(String.format("%.2f", totalRemain).replace(",", "."));
                            }
                            remainProgress = totalRemain.floatValue();
                        } else {
                            remainProgress = totalRemain.floatValue();
                            if (totalData.floatValue() == remainProgress) {
                                Log.d("TAG::>>>", "bind: " + totalData.floatValue());
                                dataLeft.setMax(totalData.floatValue());
                            } else {
                                int totalInt = totalData.intValue();

                                String[] str = totalMax.toString().split("\\.");
                                if (!TextUtils.isEmpty(str[1]) && Double.parseDouble(str[1]) > 0) {
                                    totalInt += 1;
                                }
                                dataLeft.setMax(totalInt);
                            }
                        }
                    }
                    mTotalData.setText(dataDisplay);
                    mDataSize.setText(typeDataTotal);
                }
            }
            long duration = 1500;
            if (remainProgress == dataLeft.getMax())
                duration = 800;
            final long finalDuration = duration;
            final float finalRemainProgress = remainProgress;
            final Handler delay = new Handler();
            delay.postDelayed(new Runnable() {
                @Override
                public void run() {
                    ObjectAnimator progressAnimator = ObjectAnimator.ofFloat(dataLeft, "progress", 0F, finalRemainProgress);
                    progressAnimator.setDuration(finalDuration);
                    progressAnimator.setInterpolator(new DecelerateInterpolator());
                    progressAnimator.start();
                    delay.removeCallbacks(this);
                }
            }, 1000);
            if (!dataPlansModel.getExpandable()) {
                ViewArrowShowList.setVisibility(View.GONE);
                scrollViewKeepListInternetPack.setVisibility(View.GONE);
            }

            if (dataPlansModel.getExpandable()) {
                for (InternetPackListModel data : dataPlansModel.getInternetPackList()) {
                    InternetPackDetailView internetPack = new InternetPackDetailView(mContext);
                    internetPack.setDataDisplay(data, isValuePackRow);
                    internetPack.setActionSubList(actionSubList);
                    viewListContent.addView(internetPack);
                }
                scrollViewKeepListInternetPack.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                heighViewList = scrollViewKeepListInternetPack.getMeasuredHeight();
            }

            ViewArrowShowList.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    ViewArrowShowList.setClickable(false);
                    if (dataPlansModel.getExpandable()) {
                        if (scrollViewKeepListInternetPack.getVisibility() != View.VISIBLE) {
                            scrollViewKeepListInternetPack.setVisibility(View.VISIBLE);
                            hideShowList(true, -1);
                        } else {
                            hideShowList(false, -1);
                        }
                    } else {
                        ViewArrowShowList.setClickable(true);
                    }
                }
            });

        }

        private void hideShowList(final boolean isShow, final int showMore) {
            if (isShow) {
                if (showMore > -1)
                    animMove = ValueAnimator.ofInt(heighViewList, heighViewList + showMore);
                else {
                    imageArrow.setRotation(270f);
                    imageArrow.setPaddingRelative(10, 0, 0, 0);
                    if (isSubListShow)
                        animMove = ValueAnimator.ofInt(0, heighViewList + heighViewSubValuePackList);
                    else animMove = ValueAnimator.ofInt(0, heighViewList);
                }
            } else {
                if (showMore > -1)
                    animMove = ValueAnimator.ofInt(heighViewList + showMore, heighViewList);
                else {
                    imageArrow.setRotation(180f);
                    imageArrow.setPaddingRelative(0, 0, 0, 0);
                    animMove = ValueAnimator.ofInt(heighViewList, 0);
                }
            }
            animMove.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
                @Override
                public void onAnimationUpdate(ValueAnimator animation) {
                    int val = (Integer) animation.getAnimatedValue();
                    ViewGroup.LayoutParams layoutParams = scrollViewKeepListInternetPack.getLayoutParams();
                    layoutParams.height = val;
                    scrollViewKeepListInternetPack.setLayoutParams(layoutParams);
                }
            });
            animMove.addListener(new Animator.AnimatorListener() {
                @Override
                public void onAnimationStart(Animator animation) {
                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    if (showMore == -1) {
                        if (!isShow) {
                            scrollViewKeepListInternetPack.setVisibility(View.GONE);
                            imageArrow.setRotation(180f);
                        } else {
                            imageArrow.setRotation(270f);
                        }
                        ViewArrowShowList.setClickable(true);
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                }

                @Override
                public void onAnimationRepeat(Animator animation) {
                }
            });
            animMove.setDuration(500);
            animMove.setInterpolator(new AccelerateDecelerateInterpolator());
            animMove.start();
        }

        @Override
        public void onSubListActionClick(int sizeList, boolean show) {
            hideShowList(show, sizeList);
            isSubListShow = show;
        }

        @Override
        public void onSetHeightView(int sizeList) {
            heighViewSubValuePackList = sizeList;
            heighViewList = heighViewList - sizeList;
        }
    }


}
