package com.seatel.mobilehall.ui.packages.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.seatel.mobilehall.R;
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter;
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel;
import com.seatel.mobilehall.util.customview.CustomTextView;

public class OnePlanDetailAdapter extends BaseAdapter<RecyclerView.ViewHolder> {

    private final Context mContext;
    private final ValuePackSectionModel mOnePlanDetailModel;
    private final int ONE_PLAN_DETAIL_LENGTH = 3;
    private final int VIEW_TYPE_TITLE = 0;
    private final int VIEW_TYPE_SUBTITLE = 1;

    public OnePlanDetailAdapter(Context context, ValuePackSectionModel onePlanDetailModel) {
        mContext = context;
        mOnePlanDetailModel = onePlanDetailModel;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {

        if (VIEW_TYPE_TITLE == viewType)
            return new TitleViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_one_plan_title, parent, false));
        else if (VIEW_TYPE_SUBTITLE == viewType)
            return new SubTitleViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_one_plan_sub_title, parent, false));
        else
            return new DetailViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_one_plan_detail, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        holder.itemView.setVisibility(View.INVISIBLE);
        setAnimations(holder.itemView, position);

        if (holder instanceof TitleViewHolder)
            ((TitleViewHolder) holder).onBind();
        else if (holder instanceof SubTitleViewHolder)
            ((SubTitleViewHolder) holder).onBind();
        else
            ((DetailViewHolder) holder).onBind();
    }

    @Override
    public int getItemCount() {
        return ONE_PLAN_DETAIL_LENGTH;
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    private class TitleViewHolder extends RecyclerView.ViewHolder implements RequestListener<Drawable> {

        private final TextView mTitle;
        private final TextView mSubTitle;
        private final ImageView imageView;

        public TitleViewHolder(View itemView) {
            super(itemView);

            mTitle = itemView.findViewById(R.id.text_view_title);
            mSubTitle = itemView.findViewById(R.id.text_sub_title);
            imageView = itemView.findViewById(R.id.img_one_plan);
        }

        public void onBind() {
//            mTitle.setText(mContext.getString(R.string.one_plan));
//            mTitle.setText(mTitle.getText() + "!");
            RequestOptions requestOptions = new RequestOptions();
            requestOptions.diskCacheStrategy(DiskCacheStrategy.RESOURCE);

            mSubTitle.setText(mOnePlanDetailModel.getValuePackSecTwoModel().getSubTitle());
            Glide.with(mContext).load(mOnePlanDetailModel.getDataPackDetailSecOneModel().getMobileImageUrl())
                    .fitCenter()
                    .transition(new DrawableTransitionOptions().crossFade())
                    .apply(requestOptions)
                    .listener(this)
                    .into(imageView);
        }

        @Override
        public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
            imageView.setVisibility(View.GONE);
            return false;
        }

        @Override
        public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
            return false;
        }
    }

    private class SubTitleViewHolder extends RecyclerView.ViewHolder {

        private final LinearLayout mLinearLayout;

        private SubTitleViewHolder(View itemView) {
            super(itemView);
            mLinearLayout = (LinearLayout) itemView;
        }

        private void onBind() {

            for (int i = 0; i < mOnePlanDetailModel.getValuePackSecTwoModel().getFeatureList().size(); i++) {

                View view = LayoutInflater.from(mContext).inflate(R.layout.layout_one_plan_feature, mLinearLayout, false);
                CustomTextView customTextView = view.findViewById(R.id.text_view_feature);
                String text = mOnePlanDetailModel.getValuePackSecTwoModel().getFeatureList().get(i);
                customTextView.setText(text);
                mLinearLayout.addView(view);
            }
        }
    }

    private class DetailViewHolder extends RecyclerView.ViewHolder {

        private final TextView mLinearLayout;

        private DetailViewHolder(View itemView) {
            super(itemView);
            mLinearLayout = itemView.findViewById(R.id.linear_detail);
        }

        private void onBind() {
            String strings = mOnePlanDetailModel.getValuePackSecThreeModel().getDescription();
            mLinearLayout.setText(Html.fromHtml(strings));
        }
    }

}
