package com.seatel.mobilehall.ui.packages.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.databinding.ItemLoyKobListBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.util.Constant

class LoyKobListAdapter(
    private val tableList: List<ValuePackTableModel>,
    private var type: String,
    private var isData: String,
    private var canSubscribe: Boolean,
    private val rowClick: (ValuePackTableModel) -> Unit
) : BaseAdapter<LoyKobListAdapter.ViewHolder>() {

    class ViewHolder(val binding: ItemLoyKobListBinding) : RecyclerView.ViewHolder(binding.root)

    override fun onCreateViewHolder(
        parent: ViewGroup, viewType: Int
    ): ViewHolder {
        val binding = ItemLoyKobListBinding.inflate(
            LayoutInflater.from(parent.context), parent, false
        )
        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val item = tableList[position]

        when (type) {
            "Table" -> {
                when (isData) {
                    Constant.LoyKob -> {
                        holder.binding.btnFee.text = item.valuePrice
                        holder.binding.btnBenefit.text = item.benefitOffer
                        holder.binding.btnValidity.text = item.validityDate
                        holder.binding.btnActivation.text = item.activation
                    }

                    else -> {
                        holder.binding.btnFee.text = item.valuePrice
                        holder.binding.btnBenefit.text = item.priceChange
                        holder.binding.btnValidity.text = item.validityDate
                        holder.binding.btnActivation.text = item.activation
                    }
                }

                holder.binding.run {
                    holder.binding.btnClick.visibility =
                        if (canSubscribe) View.VISIBLE else View.GONE

                    holder.binding.btnClick.setOnClickListener {
                        rowClick.invoke(item)
                    }
                }
            }

            "Addon" -> {
                val callSmsData = item.callsmsList?.joinToString(separator = ", ") ?: ""
                holder.binding.btnFee.text = item.valuePrice
                holder.binding.btnBenefit.text = item.priceChange + callSmsData
                holder.binding.btnActivation.text = item.activation

                holder.binding.btnClick.visibility =
                    if (item.activateBtn) View.VISIBLE else View.GONE

                holder.binding.btnClick.setOnClickListener {
                    rowClick.invoke(item)
                }
            }
        }
    }

    override fun getItemCount(): Int = tableList.size
}
