package com.seatel.mobilehall.ui.packages

import android.content.Context
import android.content.Intent
import android.os.Bundle
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityRoamingBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.interactor.ProductServiceDetailInteractor
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel
import com.seatel.mobilehall.ui.home.presenter.ProductServiceDetailPrsenter
import com.seatel.mobilehall.ui.packages.adapter.Roaming1Adapter
import com.seatel.mobilehall.util.SeatelAlertDialog

class RoamingActivity : BaseActivity<ActivityRoamingBinding>(),
    ProductServiceDetailInteractor.View {

    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, RoamingActivity::class.java)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityRoamingBinding {
        return ActivityRoamingBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activityEnterRightAnimation()
        ProductServiceDetailPrsenter(this, this).onProServiceDetail(
            "roaming-to-china",
            getPhoneLogin()
        )

    }

    fun scrollToLastPosition() {
        val recyclerView = binding.recyclerRoaming
        val lastPosition = recyclerView.adapter!!.itemCount + 1
        recyclerView.smoothScrollToPosition(lastPosition)
    }

    override fun onProServiceDetailSucceed(valuePackSectionModel: ValuePackSectionModel) {
        binding.recyclerRoaming.adapter =
            Roaming1Adapter(this, this.getPhoneLogin(), "any", false, valuePackSectionModel)
    }

    override fun onProServiceDetailFailed(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error)).show()
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }

    override fun getToolbarTitle(): String {
        return resources.getString(R.string.roaming_service)
    }

}