package com.seatel.mobilehall.ui.login.prefs;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;


public class FingerprintSharePreferences {

    private static final String FINGERPRINT_SHARED_PREFS = "fingerprint_shared_prefs";
    private final SharedPreferences sharedPrefs;
    private static FingerprintSharePreferences mAppShareConstant;

    public enum SharedPreKeyType {
        PHONE_NUMBER_LOGIN,
        PASSWORD_NUMBER_LOGIN,
        ENABLE_FINGERPRINT,
        FIRST_MESSAGE
    }

    private FingerprintSharePreferences(Context context) {
        this.sharedPrefs = context.getSharedPreferences(FINGERPRINT_SHARED_PREFS, Activity.MODE_PRIVATE);
    }

    public synchronized static FingerprintSharePreferences getConstant(Context context) {
        if (null == mAppShareConstant) {
            mAppShareConstant = new FingerprintSharePreferences(context);
        }
        return mAppShareConstant;
    }

    public void clearAll() {
        sharedPrefs.edit().clear().apply();
    }

    public void setPhoneLogin(String phoneLogin) {
        sharedPrefs.edit().putString(SharedPreKeyType.PHONE_NUMBER_LOGIN.toString(), phoneLogin).apply();
    }
    public String getPhoneLogin() {
        return sharedPrefs.getString(SharedPreKeyType.PHONE_NUMBER_LOGIN.toString(), "");
    }

    public void setPasswordLogin(String passwordLogin) {
        sharedPrefs.edit().putString(SharedPreKeyType.PASSWORD_NUMBER_LOGIN.toString(), passwordLogin).apply();
    }
    public String getPasswordLogin() {
        return sharedPrefs.getString(SharedPreKeyType.PASSWORD_NUMBER_LOGIN.toString(), "");
    }

    public void setEnableFingerprint(boolean enable){
        sharedPrefs.edit().putBoolean(SharedPreKeyType.ENABLE_FINGERPRINT.toString(), enable).apply();
    }

    public boolean getEnableFingerprint(){
        return sharedPrefs.getBoolean(SharedPreKeyType.ENABLE_FINGERPRINT.toString(), false);
    }

    public void setFirstTimeShowMessageFingerprint(boolean enable){
        sharedPrefs.edit().putBoolean(SharedPreKeyType.FIRST_MESSAGE.toString(), enable).apply();
    }

    public boolean getFirstTimeShowMessageFingerprint(){
        return sharedPrefs.getBoolean(SharedPreKeyType.FIRST_MESSAGE.toString(), false);
    }


}
