package com.seatel.mobilehall.ui.login.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import android.util.Log
import android.view.View
import com.seatel.mobilehall.BuildConfig
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityTermsAndConditionsBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.customview.ErrorHandleView


class TermsAndConditionsActivity : BaseActivity<ActivityTermsAndConditionsBinding>() {

    private var urlTerm = ":/assets/termsconditions/"
    override fun getViewBinding(): ActivityTermsAndConditionsBinding {
        return ActivityTermsAndConditionsBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
      //  setContentView(R.layout.activity_binding.termsAndConditions)
        activityEnterRightAnimation()
        binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        init()

    }

    fun init() {
        var urlWeb = ""
        binding.termsAndCondition.isHorizontalScrollBarEnabled = false

        if (intent.getStringExtra("URLTERM")!!.isNotEmpty()) {
            urlWeb = intent.getStringExtra("URLTERM").toString()
            binding.termsAndCondition.settings.javaScriptEnabled = true
        } else {
            var strUrl = "${BuildConfig.BASE_URL}"
            if (!TextUtils.isEmpty(strUrl))
                strUrl = strUrl.substring(0, strUrl.length - 1)
            urlWeb = "$strUrl$urlTerm"
        }
        Log.d("TAG::>>>", "init: $urlWeb")
        binding.termsAndCondition.loadUrl(urlWeb)
        binding.termsAndCondition.isScrollContainer = false
        binding.errorView.visibility = View.GONE
    }


    override fun getStringToolbarTitle(): String? {
        return getString(R.string.terms_and_condition)
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }

    companion object {
        fun launch(context: Context, urlTerm: String = "") {
            val intent = Intent(context, TermsAndConditionsActivity::class.java)
            intent.putExtra("URLTERM", urlTerm)
            context.startActivity(intent)
        }
    }
}
