package com.seatel.mobilehall.ui.invite_friend

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import com.android.volley.Request
import com.bumptech.glide.Glide
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityMyQrCodeBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.customview.ErrorHandleView
import org.json.JSONObject

class InviteFriendQrcodeActivity : BaseActivity<ActivityMyQrCodeBinding>() {


    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, InviteFriendQrcodeActivity::class.java)
            context.startActivity(intent)
        }

    }

    override fun getViewBinding(): ActivityMyQrCodeBinding {
        return ActivityMyQrCodeBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //   setContentView(R.layout.activity_my_qr_code)
        binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        getQrCode()
    }


    private fun getQrCode() {

        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/referal-qrcode/${getPhoneLogin()}"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }.setOnErrorListener {
            SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(it))
                .show()
            binding.errorView.visibility = View.GONE
        }.execute {
            val link = (it as JSONObject).optString("link")
            val message = it.optString("message")
            Glide.with(this).load(link).into(binding.ivMyQr)
            if (!message.isNullOrBlank()) {
                binding.tvMessage.visibility = View.VISIBLE
                binding.tvMessage.text = message.toString()
            }
            binding.errorView.visibility = View.GONE
        }

    }


    override fun getToolbarTitle(): String {
        return "My QR"
    }


    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }
}