package com.seatel.mobilehall.ui.invite_friend

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.BottomInviteFriendDialog

class BottomInviteFriendAdapter :
    RecyclerView.Adapter<BottomInviteFriendAdapter.BottomChooserViewHolder>() {
    private var bottomChooserModels =
        ArrayList<BottomInviteFriendDialog.BottomInviteFriendModel>()
    private var onItemClick: OnItemClick? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BottomChooserViewHolder {
        return BottomChooserViewHolder(
            LayoutInflater.from(parent.context)
                .inflate(R.layout.holder_dialog_invite_friend_item, parent, false)
        )
    }

    override fun getItemCount(): Int {
        return bottomChooserModels.size
    }

    override fun onBindViewHolder(holder: BottomChooserViewHolder, position: Int) {
        val tvNumber = holder.itemView.findViewById<TextView>(R.id.tv_number)
        val tvDate = holder.itemView.findViewById<TextView>(R.id.tv_date)
        val tvLastTopUp = holder.itemView.findViewById<TextView>(R.id.tv_last_top_up)

        tvNumber.text = bottomChooserModels[position].referee
        tvDate.text = bottomChooserModels[position].jonDate
        tvLastTopUp.text = bottomChooserModels[position].lastTopUpDate

    }

    interface OnItemClick {
        fun onClick(position: Int, data: BottomInviteFriendDialog.BottomInviteFriendModel)
        fun onDelete(position: Int, data: BottomInviteFriendDialog.BottomInviteFriendModel)
    }

    fun addItems(
        bottomChooserModels: ArrayList<BottomInviteFriendDialog.BottomInviteFriendModel>,
        onItemClick: OnItemClick
    ) {
        this.onItemClick = onItemClick
        this.bottomChooserModels.clear()
        this.bottomChooserModels.addAll(bottomChooserModels)
    }

    class BottomChooserViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView)
}