package com.seatel.mobilehall.ui.home.viewholder

import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.HolderCartSimItemBinding
import com.seatel.mobilehall.ui.home.activity.OrderActivity
import com.seatel.mobilehall.ui.home.adapter.AddOnsAdapter
import com.seatel.mobilehall.ui.home.model.CartModel
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.OrderingManager
import java.util.*

class CartSimViewHolder(private val binding: HolderCartSimItemBinding) :
    RecyclerView.ViewHolder(binding.root) {

    fun onBind(
        data: CartModel,
        notifyRow: AddOnsAdapter.MyCartAddOnClick? = null,
        rowPosition: Int? = null
    ) {
        // Binding data to views using ViewBinding
        binding.tvSimNumber.text = data.simCardNumber
        binding.tvSimPrice.text = String.format(Locale.US, "$%.2f", data.unitPrice)
        binding.tvTopUpPrice.text = String.format(Locale.US, "$%.2f", data.topUpAmount)

        if (data.planSubscription != null) {
            if (data.planSubscription.planName != null) {
                binding.tvPlan.text = data.planSubscription.planName
            }
        }

        if (data.isSimDiscount) {
            binding.tvSimCardPrice.text =
                String.format(Locale.US, "$%.2f", data.discountedCardPrice)
            binding.tvTotal.text = String.format(
                Locale.US,
                "%.2f",
                (data.totalPrice - data.cardPrice) + data.discountedCardPrice
            )
        } else {
            binding.tvSimCardPrice.text = String.format(Locale.US, "$%.2f", data.cardPrice)
            binding.tvTotal.text = String.format(Locale.US, "%.2f", data.totalPrice)
        }

        binding.checkBox.isChecked = data.isSelected
        binding.viewAddOns.visibility = View.GONE

        if (data.planSubscription != null && data.planSubscription.addOns != null && data.planSubscription.addOns!!.isNotEmpty()) {
            binding.viewAddOns.visibility = View.VISIBLE

            val addOnsAdapter = AddOnsAdapter(
                binding.root.context,
                data.planSubscription.addOns!!,
                notifyRow,
                rowPosition
            )
            binding.rlvAddons.adapter = addOnsAdapter
            binding.rlvAddons.layoutManager = LinearLayoutManager(binding.root.context)
        }

        // Loading images with Glide
        if (TextUtils.isEmpty(OrderingManager.getInstance().simPriceIconUrl)) {
            binding.imageViewSimCardPrice.setImageResource(R.drawable.ic_sim_price)
        } else {
            Glide.with(binding.root.context).load(OrderingManager.getInstance().simPriceIconUrl)
                .into(binding.imageViewSimCardPrice)
        }

        if (TextUtils.isEmpty(data.planIcon)) {
            binding.imageViewPlan.setImageResource(R.drawable.ic_one_plan)
        } else {
            Glide.with(binding.root.context).load(data.planIcon).into(binding.imageViewPlan)
        }

        if (TextUtils.isEmpty(OrderingManager.getInstance().simIconUrl)) {
            binding.imageViewSim.setImageResource(R.drawable.ic_buy_sim)
        } else {
            Glide.with(binding.root.context).load(OrderingManager.getInstance().simIconUrl)
                .into(binding.imageViewSim)
        }

        if (TextUtils.isEmpty(OrderingManager.getInstance().topUpIconUrl)) {
            binding.imageViewTopUp.setImageResource(R.drawable.ic_topup_pink)
        } else {
            Glide.with(binding.root.context).load(OrderingManager.getInstance().topUpIconUrl)
                .into(binding.imageViewTopUp)
        }

        // Hiding specific UI elements for the OrderActivity context
        if (binding.root.context is OrderActivity) {
            binding.layoutTotal.visibility = View.GONE
            binding.checkBox.visibility = View.GONE
        } else {
            val param = FrameLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT
            )
            param.topMargin = SeatelUtils.convertDpToPx(binding.root.context, 10)
            binding.root.layoutParams = param
        }
    }
}
