package com.seatel.mobilehall.ui.home.viewholder

import android.text.TextUtils
import android.view.View
import android.view.View.GONE
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.databinding.HolderCartDeviceItemBinding
import com.seatel.mobilehall.ui.home.activity.DeviceDetailActivity
import com.seatel.mobilehall.ui.home.activity.OrderActivity
import com.seatel.mobilehall.ui.home.model.CartModel
import com.seatel.mobilehall.ui.home.model.DeviceDetailViewModel
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.manager.OrderingManager
import java.util.*

class CartDeviceViewHolder(private val binding: HolderCartDeviceItemBinding) :
    RecyclerView.ViewHolder(binding.root) {

    fun onBind(data: CartModel) {
        binding.tvDeviceName.text =
            SeatelUtils.toCamelCase(String.format(Locale.US, "%s %s", data.brand, data.model))
        binding.tvDevicePrice.text = String.format(Locale.US, "$%.2f", data.unitPrice)
        binding.tvTotal.text = String.format(Locale.US, "%.2f", data.totalPrice)
        binding.tvDeviceColor.text = data.color
        binding.tvDeviceQty.text = String.format(Locale.US, "%d", data.quantity)
        binding.tvDeviceStorage.text = String.format(Locale.US, "%dGB", data.storage)
        binding.checkBox.isChecked = data.isSelected

        if (TextUtils.isEmpty(data.thumbnailUrl)) {
            Glide.with(binding.root.context).load(OrderingManager.getInstance().deviceIconUrl)
                .into(binding.imageViewDevice)
        } else {
            Glide.with(binding.root.context).load(data.thumbnailUrl).into(binding.imageViewDevice)
        }

        if (binding.root.context is OrderActivity) {
            binding.layoutTotal.visibility = GONE
            binding.checkBox.visibility = GONE
            binding.imageViewRemove.visibility = GONE
            binding.imageViewAdd.visibility = GONE
            binding.tvDeviceQty.background = null
            binding.tvDeviceQty.setPadding(0, 0, 0, 0)
        } else {
            val param = FrameLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT
            )
            param.topMargin = SeatelUtils.convertDpToPx(binding.root.context, 10)
            binding.root.layoutParams = param

            binding.layoutGoToDetail.setOnClickListener {
                val dataDeviceDetailViewer = DeviceDetailViewModel().apply {
                    isUpdatedCart = false
                    deviceId = data.deviceUrl
                    deviceColor = data.color
                    deviceColorCode = data.colorId
                    deviceStorage = data.storage
                    devicePrice = data.unitPrice
                    deviceQty = data.quantity
                    cartId = data.id
                    isUpdatedCart = true
                }
                DeviceDetailActivity.lunchWithResult(binding.root.context, dataDeviceDetailViewer)
            }
        }

        binding.imageViewRemove.setOnClickListener {
            OrderingManager.getInstance().updateCartItem(binding.root.context, data, data.quantity - 1)
        }

        binding.imageViewAdd.setOnClickListener {
            if (data.quota > 0 && data.quota < data.quantity + 1) {
                SeatelAlertDialog.with(
                    binding.root.context,
                    "${
                        SeatelUtils.translatForDialog(
                            binding.root.context,
                            "You can buy only"
                        )
                    } ${data.quota} ${
                        SeatelUtils.translatForDialog(
                            binding.root.context,
                            "of this device."
                        )
                    }"
                ).setCancelable(true).show()
                return@setOnClickListener
            }
            OrderingManager.getInstance().updateCartItem(binding.root.context, data, data.quantity + 1)
        }
    }
}
