package com.seatel.mobilehall.ui.home.presenter

import android.content.Context
import com.seatel.mobilehall.data.network.SeatelJSONArrayRequest
import com.seatel.mobilehall.ui.home.interactor.PaymentMethodListInteractor
import com.seatel.mobilehall.ui.home.model.PaymentMethodModel
import com.seatel.mobilehall.util.Constant
import org.json.JSONArray

class PaymentMethodListPresenter(private var mContext: Context) :
    PaymentMethodListInteractor.Presenter {

    private var mInternetPlanView: PaymentMethodListInteractor.View =
        mContext as PaymentMethodListInteractor.View

    override fun onGetPaymentMethod() {
        getPaymentMethodListRequest().setOnErrorListener { error ->
            mInternetPlanView.onGetPaymentMethodFailed(error)
        }.setOnResponseListener { response ->
            mInternetPlanView.onGetPaymentMethodSucceed(getMethodPaymentModel(response as JSONArray))
        }.execute()
    }

    private fun getMethodPaymentModel(response: JSONArray): ArrayList<PaymentMethodModel> {
        val methodDataModels: ArrayList<PaymentMethodModel> = ArrayList()

        for (i in 0 until response.length()) {
            val payment = PaymentMethodModel()
            payment.paymentName = response.optJSONObject(i).optString("name")
            payment.paymentIcon = response.optJSONObject(i).optString("icon")
            payment.description = response.optJSONObject(i).optString("description")
            payment.title = response.optJSONObject(i).optString("title")
            payment.discountRate = response.optJSONObject(i).optDouble("discountRate")
            payment.discountName = response.optJSONObject(i).optString("discountName")
            methodDataModels.add(payment)
            /*if(!(TextUtils.isEmpty(paymentName))) {

                when(paymentName.toLowerCase()) {
                    Constant.PaymentMethodList.WING -> {
                        methodDataModels.add(PaymentMethodModel(paymentName,response.optJSONObject(i).optString("_id"), R.drawable.ic_wing))
                    }
                    Constant.PaymentMethodList.M_PAY -> {
                        methodDataModels.add(PaymentMethodModel(paymentName,response.optJSONObject(i).optString("_id"), R.drawable.ic_mpay_blue))
                    }
                    Constant.PaymentMethodList.ALI_PAY -> {
                        methodDataModels.add(PaymentMethodModel(paymentName,response.optJSONObject(i).optString("_id"), R.drawable.ic_alipay))
                    }
                    Constant.PaymentMethodList.ABA -> {
                        methodDataModels.add(PaymentMethodModel(paymentName,response.optJSONObject(i).optString("_id"), R.drawable.ic_aba_pay))
                    }
                }
            }*/
        }
        return methodDataModels
    }

    private fun getPaymentMethodListRequest(): SeatelJSONArrayRequest {

        return object : SeatelJSONArrayRequest(mContext) {

            override fun getFunctionName(): String {
                return Constant.PAYMENT_METHODS
            }

        }
    }
}