package com.seatel.mobilehall.ui.home.presenter

import android.content.Context
import com.android.volley.Response
import com.android.volley.VolleyError
import com.seatel.mobilehall.ui.home.interactor.BuyTopUpCardInteractor
import com.seatel.mobilehall.ui.home.model.CartRequestModel
import com.seatel.mobilehall.util.manager.CartManager
import org.json.JSONObject

/**
 *
 *
 * @author Noel
 * @version
 * @created on 20-Oct-18
 */
class BuyTopUpCardPresenter(private var view: BuyTopUpCardInteractor.View?) :
    BuyTopUpCardInteractor.OnBuyTopUpCardListener {

    fun onAddCardToCard(context: Context, data: CartRequestModel<CartRequestModel.Scratch>) {
        view?.showWaiting()
        val request = CartManager.addScratchToCard(
            context,
            data,
            Response.ErrorListener { this@BuyTopUpCardPresenter.onAddCardToCardFailed(it) },
            Response.Listener { this@BuyTopUpCardPresenter.onAddCardToCardSuccess(it) })
        request.execute()
    }

    fun onDestroy() {
        view = null
    }

    override fun onAddCardToCardFailed(throwable: VolleyError) {
        view?.apply {
            this.hideWaiting()
            this.showAddCardToCardFailed(throwable)
        }
    }

    override fun onAddCardToCardSuccess(data: JSONObject?) {
        view?.apply {
            this.hideWaiting()
            this.showAddCardToCardSuccess(data)
        }
    }
}