package com.seatel.mobilehall.ui.home.model

import com.seatel.mobilehall.R

/**
 *
 *
 * @author Noel
 * @version
 * @created on 17-Oct-18
 */
class PlanSubscriptionModel() {
    var planName: String? = null
    var isSelected: Boolean = false
    var isAddOn: Boolean = false
    var isAddOnHeader: Boolean = false
    var addOnPrice: Double = 0.0
    var addOnDuraction: Int = 0
    var icon: Int = R.drawable.ic_one_plan
    var planCode: String? = ""
    var planIcon: String? = null

    constructor(planName: String?, isSelected: Boolean, icon: Int) : this() {
        this.planName = planName
        this.isSelected = isSelected
        this.icon = icon
    }

    constructor(planCode: String?, planName: String?, isSelected: Boolean, planIcon: String, isAddOne: Boolean, isAddOnHeader: Boolean) : this() {
        this.planCode = planCode
        this.planName = planName
        this.isSelected = isSelected
        this.planIcon = planIcon
        this.isAddOn = isAddOne
        this.isAddOnHeader = isAddOnHeader
    }

    override fun equals(other: Any?): Boolean {
        if (other != null && other is PlanSubscriptionModel) {
            return other.planCode.equals(this.planCode, true)
        }
        return false
    }

    override fun hashCode(): Int {
        var result = planName?.hashCode() ?: 0
        result = 31 * result + isSelected.hashCode()
        result = 31 * result + icon
        result = 31 * result + (planCode?.hashCode() ?: 0)
        return result
    }
}